package com.yidianling.ydl_pay.common.adapter

import android.annotation.SuppressLint
import android.content.Context
import androidx.recyclerview.widget.RecyclerView
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.yidianling.ydl_pay.common.actionpoint.ActionCountUtils
import com.yidianling.ydl_pay.common.actionpoint.BIConstants
import com.yidianling.ydl_pay.common.http.HttpConfig
import com.yidianling.ydl_pay.common.widget.CouponInfoDetailView
import com.yidianling.ydl_pay.R
import com.yidianling.ydl_pay.common.bean.AllCouponListBean
import com.yidianling.ydl_pay.common.bean.CommonCouponBean
import kotlinx.android.synthetic.main.item_coupon_title.view.*

/**
 * @author jiucheng
 * @描述:选择优惠券adpater
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/4/19
 */
class SelectCouponAdapter(var couponListBean: AllCouponListBean, var context: Context, var event: (selectedCouponBean: CommonCouponBean?) -> Unit) : RecyclerView.Adapter<RecyclerView.ViewHolder>() {

    private var headView: View? = null

    companion object {
        //可用优惠券title
        const val TYPE_AVAILABLE_TITLE = 0
        //可用优惠券内容
        const val TYPE_AVAILABLE_CONTENT = 1
        //不可用优惠券title
        const val TYPE_UNAVAILABLE_TITLE = 2
        //不可用优惠券内容
        const val TYPE_UNAVAILABLE_CONTENT = 3
        //headview
        const val TYPE_HEAD = 1024
    }

    fun setHeadView(headView: View) {
        this.headView = headView
    }

    private fun getHeadVieCount(): Int {
        return if (headView == null) 0 else 1
    }

    override fun getItemViewType(position: Int): Int {

        if (getHeadVieCount() > 0) {  //有头部布局
            if (position == 0) {
                return TYPE_HEAD
            }

            //可用优惠券为0
            if (couponListBean.availableCount == 0) {
                return if (position == 1) {
                    TYPE_UNAVAILABLE_TITLE
                } else {
                    TYPE_UNAVAILABLE_CONTENT
                }
            }

            return if (position == 1) {
                //可用优惠券title
                TYPE_AVAILABLE_TITLE
            } else if (position > 1 && position <= couponListBean.availableCount + 1) {
                //可用优惠券
                TYPE_AVAILABLE_CONTENT
            } else if (position == couponListBean.availableCount + 2) {
                //不可用优惠券title
                TYPE_UNAVAILABLE_TITLE
            } else {
                //不可用优惠券
                TYPE_UNAVAILABLE_CONTENT
            }

        } else {
            //可用优惠券为0
            if (couponListBean.availableCount == 0) {
                return if (position == 0) {
                    TYPE_UNAVAILABLE_TITLE
                } else {
                    TYPE_UNAVAILABLE_CONTENT
                }
            }

            return if (position == 0) {
                //可用优惠券title
                TYPE_AVAILABLE_TITLE
            } else if (position > 0 && position <= couponListBean.availableCount) {
                //可用优惠券
                TYPE_AVAILABLE_CONTENT
            } else if (position == couponListBean.availableCount + 1) {
                //不可用优惠券title
                TYPE_UNAVAILABLE_TITLE
            } else {
                //不可用优惠券
                TYPE_UNAVAILABLE_CONTENT
            }
        }
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): RecyclerView.ViewHolder {
        return when (viewType) {
            TYPE_HEAD -> {
                HeadViewHolder(headView!!)
            }
            TYPE_AVAILABLE_TITLE -> {
                TitleViewHolder(LayoutInflater.from(context).inflate(R.layout.item_coupon_title, null))
            }
            TYPE_AVAILABLE_CONTENT -> {
                CouponViewHolder(CouponInfoDetailView(context))
            }
            TYPE_UNAVAILABLE_TITLE -> {
                TitleViewHolder(LayoutInflater.from(context).inflate(R.layout.item_coupon_title, null))
            }
            TYPE_UNAVAILABLE_CONTENT -> {
                CouponViewHolder(CouponInfoDetailView(context))
            }
            else -> {
                TitleViewHolder(LayoutInflater.from(context).inflate(R.layout.item_coupon_title, null))
            }
        }
    }

    override fun getItemCount(): Int {
        if (couponListBean.availableCount + couponListBean.unAvailableCount > 0) {
            //如果没有可用优惠券，那可用优惠券标题和内容都不显示
            if (couponListBean.availableCount == 0) {
                return couponListBean.unAvailableCount + 1 + getHeadVieCount()
            }
            return couponListBean.availableCount + couponListBean.unAvailableCount + 2 + getHeadVieCount()
        } else {
            return 0 + getHeadVieCount()
        }
    }

    @SuppressLint("SetTextI18n")
    override fun onBindViewHolder(holder: RecyclerView.ViewHolder, position: Int) {
        when (getItemViewType(position)) {
            TYPE_HEAD -> {

            }
            TYPE_AVAILABLE_TITLE -> {
                (holder as TitleViewHolder).textView!!.text = "可用券(${couponListBean.availableCount})"
            }
            TYPE_AVAILABLE_CONTENT -> {
                var realPosition = if (getHeadVieCount() == 0) position else position - 1
                (holder as CouponViewHolder).view.setData(couponListBean.available[realPosition - 1], true)
                holder.view.setOnClickListener {
                    //点击的优惠券是未选中的
                    if (couponListBean.available[realPosition - 1].hasSelected != 1) {
                        repeat(couponListBean.available.size) {
                            couponListBean.available[it].hasSelected = 0
                        }
                        couponListBean.available[realPosition - 1].hasSelected = 1
                        ActionCountUtils.count(
                            HttpConfig.uid, BIConstants.PART_ID_COURSE_COUPON_PAGE,
                                BIConstants.POSITION_COURSE_COUPON_CLICK, "", "", couponListBean.available[realPosition - 1].couponId)
                        notifyDataSetChanged()
                        event(couponListBean.available[realPosition - 1])
                    } else { //点击的优惠券是选中的
                        couponListBean.available[realPosition - 1].hasSelected = 0
                        ActionCountUtils.count(
                            HttpConfig.uid, BIConstants.PART_ID_COURSE_COUPON_PAGE,
                                BIConstants.POSITION_COURSE_COUPON_CLICK, "", "", "")
                        notifyDataSetChanged()
                        event(null)
                    }


                }
            }
            TYPE_UNAVAILABLE_TITLE -> {
                (holder as TitleViewHolder).textView!!.text = "不可用券(${couponListBean.unAvailableCount})"
            }
            TYPE_UNAVAILABLE_CONTENT -> {
                var realPosition = if (getHeadVieCount() == 0) position else position - 1
                if (couponListBean.unAvailableCount > 0) {
                    if (couponListBean.availableCount == 0) {
                        (holder as CouponViewHolder).view.setData(couponListBean.unAvailable[realPosition - 1], false)
                    } else {
                        (holder as CouponViewHolder).view.setData(couponListBean.unAvailable[realPosition - couponListBean.availableCount - 2], false)
                    }
                }
            }
        }
    }

    inner class CouponViewHolder(var view: CouponInfoDetailView) : RecyclerView.ViewHolder(view)


    inner class HeadViewHolder(var view: View) : RecyclerView.ViewHolder(view)

    inner class TitleViewHolder(val view: View) : RecyclerView.ViewHolder(view) {
        var textView: TextView? = null

        init {
            textView = this.view.tv_title
        }
    }
}
