package com.yidianling.ydl_pay.common.http

import com.google.gson.Gson
import com.ydl.ydlcommon.data.http.BaseCommand
import com.ydl.ydlcommon.data.http.BaseResponse
import com.ydl.ydlcommon.utils.NetworkParamsUtils
import com.ydl.ydlnet.YDLHttpUtils
import com.yidianling.ydl_pay.common.actionpoint.ActionDataBean
import com.yidianling.ydl_pay.common.bean.*
import com.yidianling.ydl_pay.common.bean.params.CheckRequestCouponBean
import com.yidianling.ydl_pay.common.bean.params.CreateOrderRequestBean
import com.yidianling.ydl_pay.common.bean.params.GetAllCouponRequestBean
import com.yidianling.ydl_pay.common.bean.params.OrderRequestBean
import com.yidianling.ydl_pay.pay.bean.RechargeBean
import io.reactivex.Observable
import okhttp3.MediaType
import okhttp3.RequestBody

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/4/17
 */
class HttpUtils {
    companion object {
        /**
         * 获取下单的信息
         */
        fun getOrderInfo(bean: OrderRequestBean): Observable<BaseResponse<OrderInfoBean>> {
            var str = Gson().toJson(bean)
            val body = RequestBody.create(
                MediaType.parse("application/json; charset=utf-8"),
                str
            ) as RequestBody
            return YDLHttpUtils.obtainApi(PayServices::class.java).getOrderInfo(body)
        }

        /**
         * 验证课程兑换券是否可用
         */
        fun checkCourseCoupon(bean: CheckRequestCouponBean): Observable<BaseResponse<CouponCodeInfoBean>> {
            var str = Gson().toJson(bean)
            val body = RequestBody.create(
                MediaType.parse("application/json; charset=utf-8"),
                str
            ) as RequestBody
            return YDLHttpUtils.obtainApi(PayServices::class.java).checkCourseCoupon(body)
        }


        /**
         * 下单时候选择优惠券
         */
        fun selectCoupon(bean: GetAllCouponRequestBean): Observable<BaseResponse<AllCouponListBean>> {
            var str = Gson().toJson(bean)
            val body = RequestBody.create(
                MediaType.parse("application/json; charset=utf-8"),
                str
            ) as RequestBody
            return YDLHttpUtils.obtainApi(PayServices::class.java).selectCoupon(body)
        }


        /**
         * 创建订单
         */
        fun createOrder(bean: CreateOrderRequestBean): Observable<BaseResponse<PayOrderBean>> {
            var str = Gson().toJson(bean)
            val body = RequestBody.create(
                MediaType.parse("application/json; charset=utf-8"),
                str
            ) as RequestBody
            return YDLHttpUtils.obtainApi(PayServices::class.java).createOrder(body)
        }


        /**
         * 支付宝在线支付
         */
        fun getAliPayOrderId(bean: BaseCommand): Observable<BaseResponse<CommonPayRecharge>> {
            var params = NetworkParamsUtils.getPostList(bean)
            var map = NetworkParamsUtils.getMaps(params)
            return YDLHttpUtils.obtainApi(PayServices::class.java).getAliPayOrderId(map)
        }

        /**
         * 微信在线支付
         */
        fun wxPay(bean: BaseCommand): Observable<BaseResponse<CommonWXPayBean>> {
            var params = NetworkParamsUtils.getPostList(bean)
            var map = NetworkParamsUtils.getMaps(params)
            return YDLHttpUtils.obtainApi(PayServices::class.java).wxPay(map)
        }


        /**
         * 余额的接口
         */
        fun getMyBalance(bean: BaseCommand): Observable<BaseResponse<BalanceBean>> {
            var params = NetworkParamsUtils.getPostList(bean)
            var map = NetworkParamsUtils.getMaps(params)
            return YDLHttpUtils.obtainApi(PayServices::class.java).getMyBalance(map)
        }

        /**
         * 余额支付
         */
        fun payByCharge(bean: BaseCommand): Observable<BaseResponse<Any>> {
            var params = NetworkParamsUtils.getPostList(bean)
            var map = NetworkParamsUtils.getMaps(params)
            return YDLHttpUtils.obtainApi(PayServices::class.java).pay(map)
        }

        /**
         * 获得充值单号
         */
        fun recharge(bean: BaseCommand): Observable<BaseResponse<RechargeBean>> {
            var params = NetworkParamsUtils.getPostList(bean)
            var map = NetworkParamsUtils.getMaps(params)
            return YDLHttpUtils.obtainApi(PayServices::class.java).recharge(map)
        }

        /**
         * 微信充值
         */
        fun wxRecharge(bean: BaseCommand): Observable<BaseResponse<CommonWXPayBean>> {
            var params = NetworkParamsUtils.getPostList(bean)
            var map = NetworkParamsUtils.getMaps(params)
            return YDLHttpUtils.obtainApi(PayServices::class.java).wxRecharge(map)
        }

        /**
         * 行为数据埋点统计接口
         */
        internal fun actionDataCount(actionDataParams: ActionDataBean): Observable<BaseResponse<String>> {
            val body = RequestBody.create(
                MediaType.parse("application/json; charset=utf-8"),
                Gson().toJson(actionDataParams)
            )
            return YDLHttpUtils.obtainApi(PayServices::class.java).actionDataCount(body)
        }
    }
}
