package com.yidianling.ydl_pay.common.http

import com.ydl.ydlcommon.base.config.YDL_DOMAIN
import com.ydl.ydlcommon.base.config.YDL_DOMAIN_JAVA
import com.ydl.ydlcommon.data.http.BaseResponse
import com.yidianling.ydl_pay.common.bean.*
import com.yidianling.ydl_pay.pay.bean.RechargeBean
import io.reactivex.Observable
import okhttp3.RequestBody
import retrofit2.http.*

/**
 * @author jiucheng
 * @描述:支付相关的接口
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/4/16
 */
interface PayServices {

    /**
     * 获取下单的信息
     */
    @POST("auth/Order/getOrderInfo")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun getOrderInfo(@Body body: RequestBody): Observable<BaseResponse<OrderInfoBean>>

    /**
     * 验证课程兑换券是否可用
     */
    @POST("auth/course/checkCourseCoupon")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun checkCourseCoupon(@Body body: RequestBody): Observable<BaseResponse<CouponCodeInfoBean>>


    /**
     *  下单时候选择优惠券
     */
    @POST("auth/new_coupon/selectCoupon")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun selectCoupon(@Body body: RequestBody): Observable<BaseResponse<AllCouponListBean>>


    /**
     *  创建订单
     */
    @POST("auth/Order/createOrder")
    @Headers(YDL_DOMAIN + YDL_DOMAIN_JAVA)
    fun createOrder(@Body body: RequestBody): Observable<BaseResponse<PayOrderBean>>


    /**
     *  支付宝在线支付
     */
    @FormUrlEncoded
    @POST("pay/get-recharge")
    fun getAliPayOrderId(@FieldMap params: Map<String, String>): Observable<BaseResponse<CommonPayRecharge>>

    /**
     *  微信在线支付
     */
    @FormUrlEncoded
    @POST("pay/to-pay")
    fun wxPay(@FieldMap params: Map<String, String>): Observable<BaseResponse<CommonWXPayBean>>

    //行为动作埋点统计接口
    @POST("maidian/writeMaiDianData")
    fun actionDataCount(@Body body: RequestBody): Observable<BaseResponse<String>>

    //余额的接口
    @FormUrlEncoded
    @POST("uc/mybalance")
    fun getMyBalance(@FieldMap params: Map<String, String>): Observable<BaseResponse<BalanceBean>>

    //余额支付
    @FormUrlEncoded
    @POST("pay/vcount-pay")
    fun pay(@FieldMap params: Map<String, String>): Observable<BaseResponse<Any>>

    //获得充值单号
    @FormUrlEncoded
    @POST("pay/recharge")
    fun recharge(@FieldMap params: Map<String, String>): Observable<BaseResponse<RechargeBean>>

    //微信充值
    @FormUrlEncoded
    @POST("pay/recharge-wx-option")
    fun wxRecharge(@FieldMap params: Map<String, String>): Observable<BaseResponse<CommonWXPayBean>>
}