package com.yidianling.ydl_pay.common.widget

import android.annotation.SuppressLint
import android.content.Context
import android.text.TextUtils
import android.view.View
import android.view.ViewGroup
import android.widget.RelativeLayout
import com.yidianling.ydl_pay.R
import com.yidianling.ydl_pay.common.bean.CommonCouponBean
import kotlinx.android.synthetic.main.view_coupon_info_detail.view.*
import java.lang.Float
import java.math.BigDecimal

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/4/19
 */
class CouponInfoDetailView(context: Context) : RelativeLayout(context) {

    init {
        initView()
    }

    private fun initView() {
        val params = RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        layoutParams = params
        View.inflate(context, R.layout.view_coupon_info_detail, this)
    }


    @SuppressLint("SetTextI18n")
    fun setData(bean: CommonCouponBean, isUseAble: Boolean) {
        if (bean.couponType == "1") {//1兑换券
            tv_price.text = "¥" + bean.price
        } else {//优惠券
            tv_price.text = "¥" + bean.amount

            if (bean.type == "1") {
                tv_price.text = "¥" + bean.amount
            } else {
                val a1 = BigDecimal(Float.toString(bean.discount.toFloat()))
                val b1 = BigDecimal(Float.toString(10f))
                val result = a1.multiply(b1).toFloat()// 相乘结果
                val discountStr = "${result}折"
                tv_price.text = discountStr
            }
        }

        if (bean.couponType == "1") {
            tv_discountCont.text = "${bean.price}元以内可用"
            tv_discountCont.visibility = View.VISIBLE
        }
        if (!TextUtils.isEmpty(bean.discountCont)) {
            tv_discountCont.text = bean.discountCont
            tv_discountCont.visibility = View.VISIBLE
        }
        if (TextUtils.isEmpty(bean.discountCont) && bean.useCondition == "1") {
            tv_discountCont.text = "无限制"
            tv_discountCont.visibility = View.VISIBLE
        }

        tv_title.text = bean.title
        tv_duration.text = bean.effective
        tv_use_condition.text = bean.rangeCont

        if (bean.isTheFailure) {
            iv_background.setBackgroundResource(R.drawable.pay_bg_kgq)
        } else {
            iv_background.setBackgroundResource(R.drawable.pay_item_coupon_background)
        }

        if (isUseAble) {
            iv_select.visibility = View.VISIBLE
            if (bean.hasSelected == 1) {
                iv_select.setImageResource(R.drawable.pay_img_coupon_selsect)
            } else {
                iv_select.setImageResource(R.drawable.pay_img_no_select)
            }
        } else {
            iv_select.visibility = View.GONE

            tv_title.setTextColor(resources.getColor(R.color.pay_color_666666))
            tv_duration.setTextColor(resources.getColor(R.color.pay_color_666666))
            tv_use_condition.setTextColor(resources.getColor(R.color.pay_color_666666))
            iv_background.setBackgroundResource(R.drawable.pay_item_coupon_background_unuse)

            if (bean.isTheFailure) {
                iv_background.setBackgroundResource(R.drawable.pay_bg_dis_kgq)
            }
        }
    }
}
