package com.yidianling.ydl_pay.pay

import android.os.Parcel
import android.os.Parcelable


/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/24
 * update : yuanWai 2018/10/29
 */
data class PayParams(
    var inlet : Int = INLET_NORMAL,
    /**
         * 类型 1 -> 充值，2 -> 付款
         */
        var type: Int = PAY,
    /**
         * 类型标题
         */
        var title: String = "",
    /**
         * 是否显示付款保障
         */
        var visibleIndemnity: Boolean = false,
    /**
         * 支付按钮显示的文本
         */
        var btnPayText: String = "确认",
    /**
         * 需要支付的金额
         */
        var needPay: Float = 0F,
    /**
         * 订单id（如果是测评入口的话 就是测试题Id）
         */
        var payId: String = "",
    /**
         * 已使用的红包金额（代付款列表入口 使用）
         */
        var coupon_money: Float = 0F,
        var merchantType:String?=""
) : Parcelable{
    constructor(parcel: Parcel) : this(
        parcel.readInt(),
        parcel.readInt(),
        parcel.readString(),
        parcel.readByte() != 0.toByte(),
        parcel.readString(),
        parcel.readFloat(),
        parcel.readString(),
        parcel.readFloat(),
        parcel.readString()
    ) {
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeInt(inlet)
        parcel.writeInt(type)
        parcel.writeString(title)
        parcel.writeByte(if (visibleIndemnity) 1 else 0)
        parcel.writeString(btnPayText)
        parcel.writeFloat(needPay)
        parcel.writeString(payId)
        parcel.writeFloat(coupon_money)
        parcel.writeString(merchantType)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<PayParams> {
        /**
         * 1.充值 2.付款
         */
        const val RECHARGE = 1
        const val PAY = 2
        /**
         * 入口类型
         * 1.正常入口（默认） 2.测评入口
         */
        const val INLET_NORMAL     = 1
        const val INLET_TEST       = 2
        override fun createFromParcel(parcel: Parcel): PayParams {
            return PayParams(parcel)
        }

        override fun newArray(size: Int): Array<PayParams?> {
            return arrayOfNulls(size)
        }
    }
}