package com.yidianling.ydl_pay.pay

import io.reactivex.Observable
import io.reactivex.subjects.PublishSubject
import io.reactivex.subjects.Subject

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/18
 */
class RxBus private constructor(){

    companion object {
        fun getInstance(): RxBus {
            return Holder.INSTANCE
        }
    }

    private val mBus: Subject<Any>

    init {
        mBus = PublishSubject.create()
    }

    fun <T>toObservable(tClass: Class<T>): Observable<T> {
        return mBus.ofType(tClass)
    }

    fun post(any: Any) {
        mBus.onNext(any)
    }

    private object Holder {
        val INSTANCE = RxBus()
    }
}