package com.yidianling.ydl_pay.pay.redpacket

import android.os.Parcel
import android.os.Parcelable

/**
 * @author yuanwai
 * @描述:红包数据bean
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/10/23
 */
data class RedPacketBean(
                         /**
                          * 红包 ID
                          */
                         val id : String? = "",
                         /**
                          * 红包金额
                          */
                         val coupon_money : Float? = 0F,
                         /**
                          * 用户 ID
                          */
                         val uid : String? = "",
                         /**
                          * 红包标题
                          */
                         val title : String? = "",
                         /**
                          * 红包说明
                          */
                         val explain : String? = "",
                         /**
                          * 使用类型 1永久使用 2 有效期内使用
                          */
                         val use_type : Int? = 2,
                         /**
                          * 是否选中
                          */
                         val selected : Boolean? = false,
                         /**
                          * 截止日期
                          */
                         val use_time_end : String? = ""): Parcelable {
    constructor(parcel: Parcel) : this(
            parcel.readString(),
            parcel.readFloat(),
            parcel.readString(),
            parcel.readString(),
            parcel.readString(),
            parcel.readInt(),
            parcel.readByte() != 0.toByte(),
            parcel.readString()) {
    }

    override fun writeToParcel(parcel: Parcel, flags: Int) {
        parcel.writeString(id)
        parcel.writeFloat(coupon_money!!)
        parcel.writeString(uid)
        parcel.writeString(title)
        parcel.writeString(explain)
        parcel.writeInt(use_type!!)
        parcel.writeByte(if (selected!!) 1 else 0)
        parcel.writeString(use_time_end)
    }

    override fun describeContents(): Int {
        return 0
    }

    companion object CREATOR : Parcelable.Creator<RedPacketBean> {
        override fun createFromParcel(parcel: Parcel): RedPacketBean {
            return RedPacketBean(parcel)
        }

        override fun newArray(size: Int): Array<RedPacketBean?> {
            return arrayOfNulls(size)
        }
    }
}