package com.yidianling.ydl_pay.pay.redpacket

import android.annotation.SuppressLint
import android.app.Activity
import android.graphics.drawable.BitmapDrawable
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.RelativeLayout
import com.ydl.ydlcommon.utils.Utils
import com.yidianling.common.tools.RxImageTool
import com.yidianling.common.view.popupwindow.BasePopupWindow
import com.yidianling.ydl_pay.R

@Suppress("DEPRECATION")
/**
 * @author yuanWai
 * @描述:红包弹窗
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/10/23
 */
class RedPacketPopWindow : BasePopupWindow {
    //红包集合
    var list : ArrayList<RedPacketBean>? = null
    //选中红包监听器
    var listener : OnSelectListener? = null
    //选中的索引
    private var selectIndex : Int = 0

    constructor(mActivity: Activity, dataList : ArrayList<RedPacketBean>?, onSelectListener: OnSelectListener) : super(mActivity){
        if (null == list){
            list = ArrayList()
        }else{
            list!!.clear()
        }
        if (dataList != null) {
            list!!.addAll(dataList)
        }
        initPopupwindow()
        this.listener = onSelectListener
    }

    @SuppressLint("InflateParams")
    override fun initPopupwindow() {
        super.initPopupwindow()
        mView = LayoutInflater.from(mContext).inflate(R.layout.pay_redpacket_pop_layout, null, false)
        popupWindow!!.width = ViewGroup.LayoutParams.MATCH_PARENT
        popupWindow!!.height = (Utils.getScreenHeight(mContext) * 0.66).toInt()

        popupWindow!!.setBackgroundDrawable(BitmapDrawable())
        popupWindow!!.setOnDismissListener(this)
        popupWindow!!.contentView = mView
        //创建view
        createView(mView!!)
        //填充数据
        bindData()
        mView?.findViewById<RelativeLayout>(R.id.rl_notUse)?.setOnClickListener {
            selectRedPacket(null,-1)
        }
    }

    /**
     * 根据数据创建红包View
     * 如果原有的view少于数据的个数 那就add
     * 如果原有的view大于数据的个数 那就remove
     */
    private fun createView(view : View){
        val llContent = view.findViewById<LinearLayout>(R.id.ll_content)
        if (llContent.childCount - 1 < list!!.size){
            //如果数据源个数大于view个数 则add
            for (index in 0 until list!!.size){
                val marginTop = if (index == 0){
                    RxImageTool.dip2px(20f)
                }else{
                    0
                }
                if (index+1 > llContent.childCount - 1){
                    val redPacketView = RedPacketView(mContext!!,marginTop)
                    llContent.addView(redPacketView)
                }
            }
        }else{
            //如果数据源个数小于view个数 则remove
            val count = llContent.childCount - 1 - list!!.size
            if (count == 0){
                return
            }
            val end = llContent.childCount - 1 - count
            val start = llContent.childCount - 1 - 1
            for (index in start..end){
                llContent.removeViewAt(index)
            }
        }
    }

    /**
     * 根据现有的view个数进行数据填充
     */
    fun bindData(){
        if (selectIndex == -1){
            mView!!.findViewById<ImageView>(R.id.imgCheck).visibility = View.VISIBLE
        }else{
            mView!!.findViewById<ImageView>(R.id.imgCheck).visibility = View.INVISIBLE
        }
        val llContent = mView!!.findViewById<LinearLayout>(R.id.ll_content)
        for (index in 0 until list!!.size){
            val redPacketView = llContent.getChildAt(index + 1)
            if (redPacketView is RedPacketView){
                redPacketView.initData(list!![index],index,object : RedPacketView.ICheckedListener {
                    override fun checked(bean: RedPacketBean, position : Int) {
                        selectRedPacket(bean,position)
                    }
                })
                redPacketView.checked(selectIndex == index)
            }
        }
    }

    /**
     * 选择红包
     * @param bean 红包数据 如果为null 就是不使用红包
     * @param position 选择红包的索引
     */
    private fun selectRedPacket(bean: RedPacketBean?, position : Int){
        listener?.select(bean)
        selectIndex = position
        dismiss()
    }

    interface OnSelectListener {
        //选中的红包
        fun select(bean: RedPacketBean?)
    }
}