package com.ydl.ydlcommon.adapter;

import android.content.Context;
import androidx.recyclerview.widget.RecyclerView;
import android.util.SparseArray;
import android.view.View;

import java.util.List;

/**
 * Created by Wi1ls on 2016/10/13;
 */
public abstract class MyBaseAdapter<T> extends RecyclerView.Adapter<MyBaseAdapter.MyViewHolder> {
    protected Context context;
    protected List<T> data;
    protected OnItemClickListener onItemClickListener;

    public interface OnItemClickListener<T> {
        void onItemClickListener(View v, int position, T data);
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.onItemClickListener = listener;
    }

    public MyBaseAdapter(Context context, List<T> data) {
        this.context = context;
        this.data = data;
    }

    public MyBaseAdapter(Context context, List<T> data, OnItemClickListener listener) {
        this(context, data);
        this.onItemClickListener = listener;
    }

    protected static final class MyViewHolder extends RecyclerView.ViewHolder {
        private SparseArray<View> sparseArray = new SparseArray<>();

        public SparseArray<View> getSparseArray() {
            return sparseArray;
        }

        public MyViewHolder(View itemView, int... ids) {
            super(itemView);
            for (int i = 0; i < ids.length; i++) {
                sparseArray.append(ids[i], getView(ids[i]));
            }
        }

        private <Q extends View> Q getView(int id) {
            return (Q) itemView.findViewById(id);
        }

    }

    protected <Q extends View> Q getView(MyViewHolder viewHolder, int id) {
        return (Q) viewHolder.getSparseArray().get(id);
    }

    public void setData(List<T> data){
        this.data=data;
        notifyDataSetChanged();
    }

}

