package com.ydl.ydlcommon.adapter.section;

import androidx.recyclerview.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;

/**
 * Created by Jim on 2018/6/22 0022.
 */

public abstract class Section<V extends RecyclerView.ViewHolder> {

    protected int itemResourceId;//item 资源id
    protected int footerResourceId;//头资源id
    protected int headerResourceId;//尾资源id
    protected final int TYPE_HEADER = 0;
    protected final int TYPE_FOOTER = 1;
    protected final int TYPE_BODY = 2;

    /*下面的setcion值不能重复*/
    protected final int BANNER_SECTION = 100001;
    protected final int CLASSIFY_COURSE_SECTION = 100002;
    protected final int QULITY_COURSE_SECTION = 100003;
    protected final int CATEGORY_SECTION = 100004;
    protected final int TOPICS_COURSES_SECTION = 100005;
    protected final int LIST_END_SECTION = 100006;


    public Section(int itemResourceId) {
        this.itemResourceId = itemResourceId;
    }

    public Section(int headerResourceId, int footerResourceId, int itemResourceId) {
        this.itemResourceId = itemResourceId;
        this.footerResourceId = footerResourceId;
        this.headerResourceId = headerResourceId;
    }

    public boolean hasFooter() {
        return footerResourceId != 0;
    }

    public boolean hasHeader() {
        return headerResourceId != 0;
    }

    public int getHeaderResourceId() {
        return headerResourceId;
    }


    public int getItemResourceId() {
        return itemResourceId;
    }

    public void setItemResourceId(int itemResourceId) {
        this.itemResourceId = itemResourceId;
    }

    public int getFooterResourceId() {
        return footerResourceId;
    }

    public void setFooterResourceId(int footerResourceId) {
        this.footerResourceId = footerResourceId;
    }

    public void setHeaderResourceId(int headerResourceId) {
        this.headerResourceId = headerResourceId;
    }

    public int combineType(int type1, int type2) {
        return Integer.valueOf(String.valueOf(type1) + String.valueOf(type2));
    }

    public RecyclerView.ViewHolder getHeaderViewHolder(View view) {
        return null;
    }

    public RecyclerView.ViewHolder getFooterViewHolder(View view) {
        return null;
    }

    public RecyclerView.ViewHolder getItemViewHolder(View view) {
        return null;
    }

    public abstract void bindViewHolder(V holder, int position);

    public abstract int getTotalDataNum();

    public abstract int getItemViewType(int position);

    public abstract V onCreateViewHolder(ViewGroup parent, int viewType);

    public abstract boolean isBelongTo(int viewType);

    public abstract boolean isHeadType(int position);


    public abstract boolean isFooterType(int position);

    public int getSectionId() {
        return -1;
    }
}
