package com.ydl.ydlcommon.base

import android.os.Bundle
import com.ydl.ydlcommon.mvp.base.IPresenter
import com.ydl.ydlcommon.mvp.base.IView
import com.ydl.ydlcommon.mvp.delegate.MvpActivityDelegateImpl
import com.ydl.ydlcommon.mvp.delegate.MvpDelegateCallback

/**
 * Created by haorui on 2019-08-14.
 * Des: 基础MVP Activity
 */
abstract class BaseMvpActivity<V : IView, P : IPresenter<V>> : BaseActivity(),
    IView, MvpDelegateCallback<V, P> {
    protected lateinit var mPresenter: P

    protected var mvpDelegate: MvpActivityDelegateImpl<V, P>? = null
        get() {
            if (field == null) {
                this.mvpDelegate = MvpActivityDelegateImpl(this, this, true)
            }
            return field
        }

    override fun onCreate(savedInstanceState: Bundle?) {
        mvpDelegate?.onCreate(savedInstanceState)
        super.onCreate(savedInstanceState)
    }

    override fun onDestroy() {
        super.onDestroy()
        mvpDelegate?.onDestroy()
    }

    override fun onSaveInstanceState(outState: Bundle) {
        super.onSaveInstanceState(outState)
        mvpDelegate?.onSaveInstanceState(outState)
    }

    abstract override fun createPresenter(): P

    override fun getPresenter(): P {
        return mPresenter ?: throw NullPointerException("Presenter uninitialized")
    }

    override fun setPresenter(presenter: P) {
        this.mPresenter = presenter
    }

    override fun getMvpView(): V {
        return this as V
    }


}
