package com.ydl.ydlcommon.data.http

import android.text.TextUtils
import com.ydl.ydlcommon.R
import com.ydl.ydlcommon.base.BaseApp
import com.yidianling.common.tools.LogUtil
import com.yidianling.common.tools.RxNetTool
import io.reactivex.functions.Consumer

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/02/03
 */
abstract class ThrowableConsumer: Consumer<Throwable> {
    var urlParam: String? = null
    var errorCode : Int? = -1

    constructor(urlParam: String?, errorCode: Int?){
        this.urlParam = urlParam
        this.errorCode = errorCode
        LogUtil.e("http-----------urlParam=$urlParam---errorCode=$errorCode")
    }

    constructor(errorCode: Int?){
        this.errorCode = errorCode
        LogUtil.e("http-----------urlParam=$urlParam---errorCode=$errorCode")
    }

    constructor()

    init {

    }

    override fun accept(t: Throwable?) {
        if((!TextUtils.isEmpty(t?.cause?.message) && "-100" == t?.cause?.message)
                || "服务器内部错误异常" == t?.message){
            //服务器内部异常不提示异常信息
            LogUtil.e("Server internal error exception >>> "+ t.message +"<<<")
        }else{
            if (RxNetTool.isConnected(BaseApp.getApp())) {
                accept(ThrowableUtil.getMessage(t))
            }else{
                accept(BaseApp.getApp().getString(R.string.platform_network_error))
            }
        }
    }

    abstract fun accept(msg: String)

}