package com.ydl.ydlcommon.data.http

import com.google.gson.JsonParseException
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.R
import retrofit2.HttpException
import java.io.IOException
import java.net.ConnectException
import java.net.SocketTimeoutException

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/02/02
 */
internal object ThrowableUtil {

    @JvmStatic
    fun getMessage(t: Throwable?): String {
        return when (t) {
            is IOException -> BaseApp.getApp().getString(R.string.platform_data_error)
            is HttpException -> BaseApp.getApp().getString(R.string.platform_httperror)
            is JsonParseException -> BaseApp.getApp().getString(R.string.platform_httperror)
            is ConnectException -> BaseApp.getApp().getString(R.string.platform_network_error)
            is SocketTimeoutException -> BaseApp.getApp().getString(R.string.platform_timeout)
            is ApiThrowable -> t.message ?: ""
            is CustomThrowable -> t.message ?: ""
            else -> t?.message?:BaseApp.getApp().getString(R.string.platform_loadfailed)
        }
    }
}