package com.ydl.ydlcommon.data.http

import com.ydl.ydlcommon.BuildConfig
import com.ydl.ydlcommon.data.http.api.ApiRequestUtil
import com.ydl.ydlcommon.data.http.api.Command
import com.yidianling.common.tools.LogUtil
import io.reactivex.android.schedulers.AndroidSchedulers
import io.reactivex.schedulers.Schedulers

/**
 * Created by hgw on 2018/3/23.
 */
object UpLoadLogUtils {
    //错误日志上传接口
    fun upLoadLog(urlParam: String, errorCode: Int, msg: String) {
        if (BuildConfig.DEBUG){
            return
        }
        val c = Command.upLoadLoginStatus(urlParam, errorCode, msg)
        ApiRequestUtil.upLoadLoginStatus(c)
                .subscribeOn(Schedulers.io())
                .observeOn(AndroidSchedulers.mainThread())
                .subscribe({ baseResponse -> LogUtil.d("upload status : " + baseResponse.code + " " + baseResponse.msg) })
                { throwable -> LogUtil.d("upload log error: " + throwable.toString()) }
    }
}