package com.ydl.ydlcommon.data.http.api;

import com.google.gson.Gson;
import com.ydl.ydlcommon.bean.AuthBean;
import com.ydl.ydlcommon.bean.BaseUrlBean;
import com.ydl.ydlcommon.bean.JavaGlobalInfo;
import com.ydl.ydlcommon.bean.MustUP;
import com.ydl.ydlcommon.data.http.BaseAPIResponse;
import com.ydl.ydlcommon.data.http.BaseResponse;
import com.ydl.ydlcommon.data.http.FormatText;
import com.ydl.ydlcommon.data.http.params.ActionDataBean;
import com.ydl.ydlcommon.utils.NetworkParamsUtils;
import com.ydl.ydlnet.YDLHttpUtils;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.http.Body;

/**
 * 模块请求工具类
 * Created by hgw on 2018/1/23.
 */

public class ApiRequestUtil {
    //强制更新埋点
    public static Observable<BaseResponse<MustUP>> appWillUp(Command.APPWillUp cmd) {
        List<FormatText> list = NetworkParamsUtils.getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).appWillUp(NetworkParamsUtils.getMaps(list));
    }

    //上传错误日志信息
    public static Observable<BaseResponse> upLoadLoginStatus(Command.upLoadLoginStatus cmd) {
        List<FormatText> list = NetworkParamsUtils.getPostList(cmd);
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).upLoadLoginStatus(NetworkParamsUtils.getMaps(list));
    }

    /**
     * 行为数据埋点统计接口
     */
    public static Observable<BaseAPIResponse<String>> actionDataCount(ActionDataBean actionDataParams) {
        RequestBody body = RequestBody.create(MediaType.parse("application/json; charset=utf-8"), new Gson().toJson(actionDataParams));
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).actionDataCount(body);
    }

    /**
     * 获取动态密钥
     * @return
     */
    public static Observable<BaseAPIResponse<AuthBean>> getDynamicToken() {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getDynamicToken();
    }

    /**
     * 获取java全局参数接口
     * @return
     */
    public static Observable<BaseAPIResponse<JavaGlobalInfo>> getJavaGlobalInfo() {
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getJavaGlobalInfo();
    }

    /**
     * 获取登录注册模块网关
     */
    public static Observable<BaseAPIResponse<BaseUrlBean>> getBaseUrl(Map<String, Object> map){
        return YDLHttpUtils.Companion.obtainApi(NetApiStore.class).getBaseUrl(map);
    }
}
