package com.ydl.ydlcommon.data.http.api;

import com.ydl.ydlcommon.bean.AuthBean;
import com.ydl.ydlcommon.bean.BaseUrlBean;
import com.ydl.ydlcommon.bean.JavaGlobalInfo;
import com.ydl.ydlcommon.bean.MustUP;
import com.ydl.ydlcommon.data.http.BaseAPIResponse;
import com.ydl.ydlcommon.data.http.BaseResponse;

import java.util.Map;

import io.reactivex.Observable;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.FieldMap;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.POST;

import static com.ydl.ydlcommon.base.config.AppConfigKt.YDL_DOMAIN;
import static com.ydl.ydlcommon.base.config.AppConfigKt.YDL_DOMAIN_JAVA;
import static com.ydl.ydlcommon.base.config.AppConfigKt.YDL_DOMAIN_JAVA_URL;

/**
 * 网络请求api
 * Created by Emma on 2016/8/23.
 */
interface NetApiStore {
    //强制更新埋点
    @FormUrlEncoded
    @POST("site/cmd")
    Observable<BaseResponse<MustUP>> appWillUp(@FieldMap Map<String, String> params);

    //登录异常上传接口日志
    @POST("uc/log")
    @FormUrlEncoded
    Observable<BaseResponse> upLoadLoginStatus(@FieldMap Map<String, String> maps);

    //行为动作埋点统计接口
    @Headers(YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    @POST("data/bigdata/maidian/writeMaiDianData")
    Observable<BaseAPIResponse<String>> actionDataCount(@Body RequestBody body);

    @Headers(YDL_DOMAIN+ YDL_DOMAIN_JAVA_URL)
    @GET("risk/key/info")
    Observable<BaseAPIResponse<AuthBean>> getDynamicToken();

    @Headers(YDL_DOMAIN+ YDL_DOMAIN_JAVA)
    @GET("config/socket-config")
    Observable<BaseAPIResponse<JavaGlobalInfo>> getJavaGlobalInfo();

    @Headers({YDL_DOMAIN+ YDL_DOMAIN_JAVA,"userPort:1","Content-type:application/json;charset=UTF-8"})
    @POST("systemconfig/get_gateway_base_url")
    Observable<BaseAPIResponse<BaseUrlBean>> getBaseUrl(@Body Map<String, Object> map);
}
