package com.ydl.ydlcommon.modular

import android.content.Context
import android.os.Bundle
import android.os.Parcelable
import com.alibaba.android.arouter.facade.template.IProvider
import com.alibaba.android.arouter.launcher.ARouter
import com.ydl.ydlcommon.BuildConfig
import com.ydl.ydlcommon.utils.LogUtil


/**
 * Created by haorui on 2019-09-21 .
 * Des:查找 Arouter 服务封装类
 */
fun <T> findRouteService(clz: Class<T>): T {
    val service = ARouter.getInstance().navigation(clz)
    if (service != null) return service
    if (BuildConfig.DEBUG) {
        throw IllegalStateException("check module dependency by [${clz.simpleName}]")
    }
    return service
}


fun route(context: Context?, route: String, vararg params: Pair<String, Any?>) {
    val build = ARouter.getInstance().build(route)
    params.forEach {
        when (val value = it.second) {
            is Boolean -> {
                build.withBoolean(it.first, value)
            }
            is Char -> {
                build.withChar(it.first, value)
            }
            is Int -> {
                build.withInt(it.first, value)
            }
            is Long -> {
                build.withLong(it.first, value)
            }
            is Float -> {
                build.withFloat(it.first, value)
            }
            is Double -> {
                build.withDouble(it.first, value)
            }
            is Short -> {
                build.withShort(it.first, value)
            }
            is Byte -> {
                build.withByte(it.first, value)
            }
            is String -> {
                build.withString(it.first, value)
            }
            is Bundle -> {
                build.withBundle(it.first, value)
            }
            is CharSequence -> {
                build.withCharSequence(it.first, value)
            }
            is Parcelable -> {
                build.withParcelable(it.first, value)
            }
        }
    }
    if (context == null) {
        build.navigation()
    } else {
        build.navigation(context)
    }
}

object ModularServiceManager {

    private val routerMap: HashMap<String, IProvider> = HashMap()

    @Deprecated("使用findRouteService代替",
        ReplaceWith("findRouteService(IPlatformUserModuleService::class.java)", "import com.ydl.ydlcommon.modular.findRouteService")
    )
    fun getPlatformUserService(): IPlatformUserModuleService? {
        return provide(IPlatformUserModuleService::class.java)
    }

    @Deprecated("使用findRouteService代替",
        ReplaceWith("findRouteService(clz)", "import com.ydl.ydlcommon.modular.findRouteService")
    )
    fun <T : IProvider> provide(clz: Class<T>, path: String): T {

        var provider: IProvider? = null
        val simpleName = clz.simpleName;

        if (routerMap[simpleName]!=null){
            return routerMap[simpleName] as T
        }

        try {
            val navigation = ARouter.getInstance()
                .build(path)
                .navigation()

            provider = navigation as IProvider

            routerMap[simpleName] = provider

        } catch (e: Exception) {
            LogUtil.e(e.message)
            return throw ServiceNotFoundException("请检查您是否依赖于包含以下内容的模块: $simpleName, path is $path")
        }

        return provider as T
    }

    @Deprecated("使用findRouteService代替",
        ReplaceWith("findRouteService(clz)", "import com.ydl.ydlcommon.modular.findRouteService")
    )
    fun <T : IProvider> provide(clz: Class<T>): T {

        var provider: IProvider? = null
        val simpleName = clz.simpleName;
        if (routerMap[simpleName]!=null){
            return routerMap[simpleName] as T
        }
        try {
            provider = ARouter.getInstance().navigation(clz)
            if (provider == null){
                LogUtil.e("provide : Service Not Found ")
            }
            routerMap[simpleName] = provider
        } catch (e: Exception) {
            LogUtil.e(e.toString())
            return throw ServiceNotFoundException("请检查您是否依赖于包含以下内容的模块: $simpleName")
        }

        return provider as T
    }

    /**
     * 用以判断是否接入依赖某业务模块
     */
    fun <T : IProvider> isDependByClz(clz: Class<T>): Boolean {
        var provider: IProvider? = null

        try {
            provider = ARouter.getInstance().navigation(clz)
            return provider != null
        } catch (e: Exception) {
            LogUtil.e(e.toString())
        }

        return provider != null
    }
}