package com.ydl.ydlcommon.mvp.base

import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleObserver
import androidx.lifecycle.LifecycleOwner
import androidx.lifecycle.OnLifecycleEvent


/**
 * Created by haorui on 2019-08-14.
 * Des:简化版基础 Presenter，去除Model层
 */
abstract class SimplePresenter<V : IView> : IPresenter<V>, LifecycleObserver {

    open lateinit var mView: V

    override fun attachView(view: V) {
        this.mView = view
        if (view is LifecycleOwner) {
            (view as LifecycleOwner).lifecycle.addObserver(this)
        }
    }

    override fun detachView() {
        //保证 Activity 结束时取消所有正在执行的订阅
        unDispose()
    }


    private fun unDispose() {
        //Activity 结束时取消所有正在执行的订阅

    }

    @OnLifecycleEvent(Lifecycle.Event.ON_DESTROY)
    fun onDestroy(owner: LifecycleOwner) {
        owner.lifecycle.removeObserver(this)
    }

    override fun destroy() {

    }
}