package com.ydl.ydlcommon.mvp.lce.view

import android.content.Context
import android.util.AttributeSet
import android.view.View
import android.widget.RelativeLayout
import com.ydl.ydl_image.module.GlideApp
import com.ydl.ydlcommon.R
import kotlinx.android.synthetic.main.platform_logo_loading_view.view.*

/**
 * Created by haorui on 2019-08-14.
 * Des: YDL 加载状态显示View，配置BaseLceActivity使用
 *
 *      1. 加载中状态
 *      2. 数据为空状态
 *      3. 加载错误状态
 */
class YDLStateView(context: Context?, attrs: AttributeSet?) : RelativeLayout(context, attrs), ILceViewState {

    override fun setListener(listener: ILceViewState.LogoLoadingListener) {
        this.mListener = listener
    }

    var mListener: ILceViewState.LogoLoadingListener? = null

    init {
        initView()
    }

    private fun initView() {
        View.inflate(context, R.layout.platform_logo_loading_view, this)

        GlideApp.with(this).load(R.drawable.platform_loading_logo).into(logo_loading_gif)

        reset_btn.setOnClickListener {
            mListener?.onDataResetClick()
        }

        back_btn.setOnClickListener {
            mListener?.onBackClick()
        }
    }
    override fun showLoading() {
        logo_loading_gif_rl.visibility = View.VISIBLE
        empty_rl.visibility = View.GONE
        loading_rl.visibility = View.VISIBLE
    }

    override fun hideLoading() {
        logo_loading_gif_rl.visibility = View.GONE
        empty_rl.visibility = View.GONE
        loading_rl.visibility = View.GONE
    }

    override fun showError(msg: String) {
        logo_loading_gif_rl.visibility = View.GONE
        empty_rl.visibility = View.VISIBLE
        loading_rl.visibility = View.VISIBLE
        msg?.let {
            hint_msg.text = msg
        }
    }

    override fun showEmpty(msg: String) {
        logo_loading_gif_rl.visibility = View.GONE
        empty_rl.visibility = View.VISIBLE
        loading_rl.visibility = View.VISIBLE
        msg?.let {
            hint_msg.text = msg
        }
    }
}