package com.ydl.ydlcommon.router

/**
 * @author yuanWai
 * @描述:路由地址常量
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/12/27
 */
interface IYDLRouterConstant{
    companion object {
        const val ROUTER_BASE = "ydl-user://"
        //倾诉频道页
        const val ROUTER_CONFIDE_HOME = ROUTER_BASE+"confide/home"
        //课程频道页
        const val ROUTER_COURSE_HOME  = ROUTER_BASE+"course/home"
        //课程列表页
        const val ROUTER_COURSE_LIST  = ROUTER_BASE+"course/list"
        //测评频道首页
        const val ROUTER_TEST_HOME = ROUTER_BASE + "tests/home"
        //测评列表页
        const val ROUTER_TEST_LIST = ROUTER_BASE + "ceshi/list"
        //咨询列表页（专家服务搜索页面）
        const val ROUTER_CONSULT_LIST = ROUTER_BASE + "consult/list"
        //课程专题页面
        const val ROUTER_COURSE_SPECIAL = ROUTER_BASE + "course/special"
        //测评详情页
        const val ROUTER_TEST_DETAIL = ROUTER_BASE + "ceshi/detail"
        //h5页面 课程详情页、咨询详情页（专家主页）、倾诉详情页（拨打电话）
        const val ROUTER_H5_H5 = ROUTER_BASE + "h5/h5"
        //心事动态频道页（首页--问答）
        const val ROUTER_ANSWERS_HOME = ROUTER_BASE + "answers/home"
        //话题详情页
        const val ROUTER_TOPIC_DETAIL = ROUTER_BASE + "topic/detail"
        //冥想页面
        const val ROUTER_MUSE = ROUTER_BASE + "module/muse"
        //fm列表页
        const val ROUTER_FM_LIST = ROUTER_BASE + "fm/list"
        //fm详情页
        const val ROUTER_FM_DETAIL = ROUTER_BASE + "fm/detail"
        //私聊窗口页面
        const val ROUTER_CHAT_PRIVATE = ROUTER_BASE + "chat/private"
        //文章列表页
        const val ROUTER_ARTICLE_LIST = ROUTER_BASE + "article/list"
        //我的红包
        const val ROUTER_MINE_REDPACKET = ROUTER_BASE + "mine/redpacket"
        //登录页面
        const val ROUTER_MINE_LOGIN = ROUTER_BASE + "mine/login"
        //课程搜索页面
        const val ROUTER_COURSE_SEARCH = ROUTER_BASE + "course/search"
        //支付页面
        const val ROUTER_PAY_PAY = ROUTER_BASE + "pay/pay"
        //统计埋点
        const val ROUTER_BURRY_POINT = ROUTER_BASE + "burry/point"
        //首页tab
        const val ROUTER_MAIN_TAB = ROUTER_BASE + "main/tab"
        //咨询下单页
        const val ROUTER_APPOINTMENT_ZIXUN = ROUTER_BASE + "appointment/zixun"

        //导医过渡页面
        const val ROUTER_CHAT_CONSULT_ASSISTANT = ROUTER_BASE + "chat/ChatService"
        //冥想过渡页面
        const val ROUTER_MUSE_CENTER = ROUTER_BASE + "muse/MuseService"
        //冥想播放页面
        const val ROUTER_MUSE_PLAY = ROUTER_BASE + "muse/play"
        /**
         * 参数名称
         */
        const val EXTRA_LISTTYPE  = "listType"
        const val EXTRA_URL       = "url"
        const val EXTRA_ISFREE    = "isFree"
        const val EXTRA_ID        = "id"
        const val EXTRA_TOUID     = "toUid"
        const val EXTRA_USERTYPE  = "userType"
        const val EXTRA_CLASSNAME = "className"
        const val EXTRA_CLICKNAME = "clickName"
        const val EXTRA_TAB       = "tab"
        const val EXTRA_CATEID    = "cateId"
        const val EXTRA_CATETITLE = "cateTitle"
        const val HASCATEID = "hascateid"
        const val EXTRA_SHOWTYPE = "showType"
        const val EXTRA_KEYWORD   = "keyword"
        const val EXTRA_RED_PACKET = "by_red_packet"
        const val EXTRA_CONFIDEDID = "confidedId"
        const val EXTRA_DOCTORID = "doctorId"
        const val GO_CRITERIA = "go_criteria"

        /**
         * 冥想模块额外参数
         */
        const val MUSIC_URL     = "musicUrl"
        const val DATA_JSON     = "dataJson"
    }
}