package com.ydl.ydlcommon.router

import android.app.Application
import androidx.annotation.StringRes
import com.ydl.ydlcommon.base.BaseApp
import com.ydl.ydlcommon.data.PlatformDataManager
import com.ydl.ydlcommon.utils.remind.ToastHelper

/**
 * author : Zhangwenchao
 * e-mail : zhangwch@yidianling.com
 * time   : 2018/04/24
 *
 *  项目通用模块对外提供的方法
 */
class YdlCommonOut {

    companion object {

        fun showToast(content: String) {
            ToastHelper.show(content)
        }

        fun showToast(@StringRes stringId: Int) {
            ToastHelper.show(stringId)
        }

        fun getApp(): Application {
            return BaseApp.getApp()
        }

        fun getChannelName(): String {
            return PlatformDataManager.getRam().getChannelName()
        }
    }
}