package com.ydl.ydlcommon.utils

import android.view.View
import android.view.animation.AccelerateInterpolator
import android.view.animation.Animation
import android.view.animation.TranslateAnimation


/**
 * @author yuanWai
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/2/19
 */
class AnimUtils {
    companion object {
        fun slideToUp(view: View) {
            val slide = TranslateAnimation(
                Animation.RELATIVE_TO_SELF, 0.0f,
                Animation.RELATIVE_TO_SELF, 0.0f, Animation.RELATIVE_TO_SELF,
                1.0f, Animation.RELATIVE_TO_SELF, 0.0f
            )
            slide.duration = 400
            slide.fillAfter = true
            slide.isFillEnabled = true
            view.startAnimation(slide)
            slide.setAnimationListener(object : Animation.AnimationListener {
                override fun onAnimationRepeat(animation: Animation?) {

                }

                override fun onAnimationEnd(animation: Animation?) {

                }

                override fun onAnimationStart(animation: Animation?) {

                }
            })
        }

        fun slideToDown(view: View?) {
            val animation = TranslateAnimation(
                Animation.RELATIVE_TO_SELF, 0F, Animation.RELATIVE_TO_SELF, 0f,
                Animation.RELATIVE_TO_SELF, -1.0f, Animation.RELATIVE_TO_SELF, 0F
            )
            animation.duration = 400
            animation.repeatMode = Animation.REVERSE
            animation.interpolator = AccelerateInterpolator()
            animation.fillAfter = true
            view?.startAnimation(animation)
        }
    }
}