package com.ydl.ydlcommon.utils;

import android.content.Context;
import android.text.TextUtils;

import com.yidianling.common.tools.LogUtil;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

/**
 * @author yuanwai
 * @version 3.6.80
 * @描述:app 进程工具类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/10/23
 */
public class AppProgressUtils {

    /***
     * 注：如果你的 APP 中有第三方的服务启动，请在初始化 SDK（EMClient.getInstance().init(applicationContext, options)）方法的前面添加以下相关代码
     * （相应代码也可参考 Demo 的 application），使用 EaseUI 库的就不用理会这个。
     * @return
     */
    public static boolean isMainProcess(Context application) {
        String processAppName =  getProcessName(application);
        if(TextUtils.isEmpty(processAppName))
            return true;
        // 如果APP启用了远程的service，此application:onCreate会被调用2次
        // 为了防止环信SDK被初始化2次，加此判断会保证SDK被初始化1次
        // 默认的APP会在以包名为默认的process name下运行，如果查到的process name不是APP的process name就立即返回
        if (!processAppName.equalsIgnoreCase(application.getApplicationContext().getPackageName())) {
            // 则此application::onCreate 是被service 调用的，直接返回
            return false;
        }
        return true;
    }

    private static String getProcessName(Context app) {
        String processName = null;
        try {
            Field loadedApkField = app.getClass().getField("mLoadedApk");
            loadedApkField.setAccessible(true);
            Object loadedApk = loadedApkField.get(app);

            Field activityThreadField = loadedApk.getClass().getDeclaredField("mActivityThread");
            activityThreadField.setAccessible(true);
            Object activityThread = activityThreadField.get(loadedApk);

            Method getProcessName = activityThread.getClass().getDeclaredMethod("getProcessName");
            processName = (String) getProcessName.invoke(activityThread);
        } catch (Exception e) {
            LogUtil.e("AppProgressUtils " + e.getMessage());
        }
        return processName;
    }
}
