package com.ydl.ydlcommon.utils;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import com.meituan.android.walle.WalleChannelReader;
import com.ydl.ydlcommon.base.BaseApp;
import com.ydl.ydlcommon.base.config.ChannelConfig;
import com.yidianling.common.tools.LogUtil;
import com.ydl.ydlcommon.BuildConfig;
import com.ydl.ydlcommon.data.PlatformDataManager;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.HashMap;

/**
 * 埋点工具类
 * Created by hgw on 2017/5/18.
 */

public class BuryPointUtils {

    //是否开启debug模式
//    private static boolean isDebug = false;
    private static boolean isDebug = BuildConfig.DEBUG;

    // 数据接收的 URL
    private static String SA_SERVER_URL = "http://shence.yidianling.com:8006/sa?project=default";

    // 配置分发的 URL
    private static String SA_CONFIGURE_URL = "http://shence.yidianling.com:8006/config/?project=default";
    // Debug 模式选项
    //   SensorsDataAPI.DebugMode.DEBUG_OFF - 关闭 Debug 模式
    //   SensorsDataAPI.DebugMode.DEBUG_ONLY - 打开 Debug 模式，校验数据，但不进行数据导入
    //   SensorsDataAPI.DebugMode.DEBUG_AND_TRACK - 打开 Debug 模式，校验数据，并将数据导入到 Sensors Analytics 中
    // 注意！请不要在正式发布的 App 中使用 Debug 模式！
//    private static SensorsDataAPI.DebugMode SA_DEBUG_MODE = SensorsDataAPI.DebugMode.DEBUG_OFF;

    private static Context context;

    private HashMap<String, Object> mHashMap;
    private static BuryPointUtils sBuryPointUtils = new BuryPointUtils();

    public static BuryPointUtils getInstance() {
        return sBuryPointUtils;
    }

    //初始化及其配置
    public static void init() {
        context = BaseApp.Companion.getApp();
//        SensorsDataAPI.sharedInstance(context);
        if (!isDebug) {
//            SA_DEBUG_MODE = SensorsDataAPI.DebugMode.DEBUG_OFF;
            //正式项目地址
            SA_SERVER_URL = "http://shence.yidianling.com:8006/sa?project=production";
            SA_CONFIGURE_URL = "http://shence.yidianling.com:8006/config/?project=production";
        }
        // 初始化 SDK
//        SensorsDataAPI.sharedInstance(
//                context,                               // 传入 Context
//                SA_SERVER_URL,                      // 数据接收的 URL
//                SA_CONFIGURE_URL,                   // 配置分发的 URL
//                SA_DEBUG_MODE);                     // Debug 模式选项
//
//        // 允许开发者的设备连接可视化埋点管理界面
//        SensorsDataAPI.sharedInstance(context).enableEditingVTrack();

        // 将'平台类型'作为事件公共属性，后续所有 track() 追踪的事件都将设置 "platformType" 属性，且属性值为 "Android"
        try {
            //注册马甲名称
            JSONObject properties = new JSONObject();
            properties.put("platformType", "Android-" + getShareTitle());
//            SensorsDataAPI.sharedInstance(context).registerSuperProperties(properties);

            //渠道统计
            // 设置渠道名称属性
            String channelName = WalleChannelReader.getChannel(BaseApp.Companion.getApp());
            JSONObject properties1 = new JSONObject();
            properties1.put("$utm_source", channelName);
            // 设置广告名称属性
            properties.put("$utm_campaign", "广告A");
            // 追踪渠道效果
//            SensorsDataAPI.sharedInstance(context).trackInstallation("AppInstall", properties1);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        // 打开自动采集, 并指定追踪哪些 AutoTrack 事件
//        List<SensorsDataAPI.AutoTrackEventType> eventTypeList = new ArrayList<>();
//        // $AppStart
//        eventTypeList.add(SensorsDataAPI.AutoTrackEventType.APP_START);
//        // $AppEnd
//        eventTypeList.add(SensorsDataAPI.AutoTrackEventType.APP_END);
//        // $AppViewScreen
//        eventTypeList.add(SensorsDataAPI.AutoTrackEventType.APP_VIEW_SCREEN);
//        // $AppClick
//        eventTypeList.add(SensorsDataAPI.AutoTrackEventType.APP_CLICK);
//        SensorsDataAPI.sharedInstance(context).enableAutoTrack(eventTypeList);

    }

    private static String getShareTitle() {
        String ffrom = PlatformDataManager.INSTANCE.getRam().getChannelName();
        if (ffrom.startsWith(ChannelConfig.ATK_3.name())) {
            return "秘密倾诉";
        } else if (ffrom.startsWith(ChannelConfig.ATK_4.name())) {
            return "心理测试";
        } else if (ffrom.startsWith(ChannelConfig.ATK_5.name())) {
            return "心理FM";
        } else if (ffrom.startsWith(ChannelConfig.ATK_6.name())) {
            return "525心理";
        } else if (ffrom.startsWith(ChannelConfig.ATK_7.name())) {
            return "心理咨询";
        } else {
            return "壹点灵";
        }
    }

    //标记事件启动时间
    public static void eventStartTime(String eventName) {
// 调用 trackTimer("ViewProduct") 标记事件启动时间
//        SensorsDataAPI.sharedInstance(context).trackTimer(eventName);
    }

    //埋点
    public static void buryPoint(String eventName, JSONObject properties) {
//        SensorsDataAPI.sharedInstance(context).track(eventName, properties);
    }

    public BuryPointUtils createMap() {
        mHashMap = new HashMap<>();
        return sBuryPointUtils;
    }

    public BuryPointUtils put(String key, Object value) {
        if (value == null) {
            value = "";
        }
        if (mHashMap != null && !TextUtils.isEmpty(key)) {
            mHashMap.put(key, value);
        }
        return sBuryPointUtils;
    }

    public BuryPointUtils put(String key, Integer value) {
        if (value == null) {
            value = 0;
        }
        if (mHashMap != null && !TextUtils.isEmpty(key)) {
            mHashMap.put(key, value);
        }
        return sBuryPointUtils;
    }

    public BuryPointUtils put(String key, String value) {
        if (value == null) {
            value = "";
        }
        if (mHashMap != null && !TextUtils.isEmpty(key)) {
            mHashMap.put(key, value);
        }
        return sBuryPointUtils;
    }

    public BuryPointUtils put(String key, Boolean value) {
        if (value == null) {
            value = false;
        }
        if (mHashMap != null && !TextUtils.isEmpty(key)) {
            mHashMap.put(key, value);
        }
        return sBuryPointUtils;
    }

    public BuryPointUtils put(String key, Long value) {

        if (value == null) {
            value = 0l;
        }
        if (mHashMap != null && !TextUtils.isEmpty(key)) {
            mHashMap.put(key, value);
        }
        return sBuryPointUtils;
    }

    public void burryPoint(String eventName) {
        LogUtil.d("burryPoint: " + eventName);
        if (mHashMap == null) {
            return;
        }
        try {
            JSONObject properties = new JSONObject();
            for (String key : mHashMap.keySet()) {
                properties.put(key, mHashMap.get(key));
            }
//            SensorsDataAPI.sharedInstance(context).track(eventName, properties);
        } catch (Exception e) {
            LogUtil.e("burry point error: " + e);
        } finally {
            mHashMap = null;
        }
    }

    //此方法用于 Activity 内 切换页面的时候调用，用于记录 $AppViewScreen 事件
    public void trackViewScreen(Activity activity, String title, String screenName) {
        try {
            JSONObject properties = new JSONObject();
            properties.put("$title", title);
            properties.put("$screen_name", screenName);
//            SensorsDataAPI.sharedInstance(activity).trackViewScreen(null, properties);
        } catch (JSONException e) {
            e.printStackTrace();
        } finally {
            mHashMap = null;
        }
    }


    //神策给每个用户分配的distinct_id与用户真实uid绑定
    public static void bindUid(String uid) {
//        SensorsDataAPI.sharedInstance(context).login(uid);
    }

}
