package com.ydl.ydlcommon.utils

import android.content.Context
import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.util.Base64
import com.hjq.permissions.Permission
import com.hjq.permissions.XXPermissions
import com.yidianling.common.tools.ToastUtil
import io.reactivex.Observable
import io.reactivex.disposables.Disposable
import io.reactivex.schedulers.Schedulers
import saveToAlbum

class ImageUtil {

    companion object {

        private fun saveToAlbum(context: Context, bitmap: Bitmap?): Disposable {
            return Observable.create<Boolean> {
                bitmap?.let { pic ->
                    pic.saveToAlbum(
                        context,
                        "${System.currentTimeMillis()}.png"
                    )
                    it.onNext(true)
                } ?: let { _ ->
                    it.onNext(false)
                }
            }.subscribeOn(Schedulers.io())
                .subscribe {
                    if (it) {
                        ToastUtil.toastShort("图片已保存至相册")
                    }
                    else ToastUtil.toastShort("保存失败")
                }
        }

        private fun convertBase64ToBitmap(base64: String): Bitmap? {
            val decode = Base64.decode(base64, Base64.DEFAULT)
            return BitmapFactory.decodeByteArray(decode, 0, decode.size)
        }

        /**
         * base64字符串
         * 保存图片到相册
         */
        @JvmStatic
        fun savePicture(context: Context, base64: String?): Disposable? {
            var disposable: Disposable? = null
            base64?.run {
//                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
//                    disposable = saveToAlbum(context, convertBase64ToPic(this))
//                } else {
                val permissions =
                    arrayOf(Permission.READ_EXTERNAL_STORAGE, Permission.WRITE_EXTERNAL_STORAGE)
                if (XXPermissions.isGrantedPermission(context, permissions)) {
                    disposable = saveToAlbum(context, convertBase64ToBitmap(this))
                } else {
                    XXPermissions.with(context)
                        .permission(permissions)
                        .request { _, _ ->
                            disposable = saveToAlbum(context, convertBase64ToBitmap(this))
                        }
                }
//                }
            }
            return disposable
        }

        /**
         * bitmap
         * 保存图片到相册
         */
        @JvmStatic
        fun savePicture(context: Context, bitmap: Bitmap?): Disposable? {
            var disposable: Disposable? = null
//                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
//                    disposable = saveToAlbum(context, bitmap)
//                } else {
            val permissions =
                arrayOf(Permission.READ_EXTERNAL_STORAGE, Permission.WRITE_EXTERNAL_STORAGE)
            if (XXPermissions.isGrantedPermission(context, permissions)) {
                disposable = saveToAlbum(context, bitmap)
            } else {
                XXPermissions.with(context)
                    .permission(permissions)
                    .request { _, _ ->
                        disposable = saveToAlbum(context, bitmap)
                    }
            }
//                }
            return disposable
        }
    }

}