package com.ydl.ydlcommon.utils;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.PopupWindow;
import com.ydl.ydlcommon.view.MoreClickView;


/**
 * Created by Wi1ls on 2016/10/17;
 */
public class PopUtils {
    public static PopupWindow showMoreItem(Context context, View view, int offX, int offY){
        MoreClickView v=  new MoreClickView(context);
        WindowManager windowManager= (WindowManager) context.getSystemService(Context.WINDOW_SERVICE);

        final PopupWindow popupWindow=new PopupWindow(v, windowManager.getDefaultDisplay().getWidth(),
                windowManager.getDefaultDisplay().getHeight());
        v.setPopupWindow(popupWindow);
        popupWindow.setFocusable(false);
        popupWindow.setOutsideTouchable(true);
        popupWindow.setBackgroundDrawable(new BitmapDrawable());
//        popupWindow.showAsDropDown(view);
        popupWindow.showAtLocation(view, Gravity.CENTER,0,0);
        return popupWindow;
    }

    public static PopupWindow showHomePop(Context context,View content,View view){

        final PopupWindow popupWindow=new PopupWindow(content, ViewGroup.LayoutParams.MATCH_PARENT,
                ViewGroup.LayoutParams.MATCH_PARENT);
        popupWindow.setFocusable(false);
        popupWindow.setOutsideTouchable(true);
        popupWindow.setBackgroundDrawable(new BitmapDrawable());
        popupWindow.showAsDropDown(view, 0,0);
        return popupWindow;
    }
}
