package com.ydl.ydlcommon.utils;


import android.text.TextUtils;

import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.PatternSyntaxException;

/**
 * 字符串转换工具类
 * Created by xiongyu on 2017/3/17.
 */

public class StringUtils {

    /**
     * 处理文字中未显示的自定义表情
     *
     * @param orgin_str
     * @return
     */
    public static String CustomEmojiSub(String orgin_str) {
        int pre_index = orgin_str.lastIndexOf("[");
        if (pre_index != -1) {
            if (orgin_str.substring(pre_index).indexOf("]") != -1) {//表示包含了最后一个自定义表情
                return orgin_str;
            } else {
                return orgin_str.substring(0, pre_index) + "...";
            }
        } else {
            return orgin_str;
        }
    }


    public static String UrlToString(String url_str) {
        String deal_str = "";
        String type_str = url_str.substring(url_str.lastIndexOf("."));
        deal_str = url_str.replace("http", "ydl");
        deal_str = deal_str.replace(":", "a");
        deal_str = deal_str.replace("/", "a");
        deal_str = deal_str.replace(".", "a");
        deal_str = deal_str + "." + type_str;
        return deal_str;
    }

    /**
     * 检测是否有emoji表情
     *
     * @param source
     * @return
     */
    public static boolean containsEmoji(String source) {
        int len = source.length();
        for (int i = 0; i < len; i++) {
            char codePoint = source.charAt(i);
            if (!isEmojiCharacter(codePoint)) { //如果不能匹配,则该字符是Emoji表情
                return true;
            }
        }
        return false;
    }

    /**
     * 判断该字符串是否为中文
     *
     * @param string
     * @return
     */
    public static boolean isChinese(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); i++) {
            n = (int) string.charAt(i);
            if (!(19968 <= n && n < 40869)) {
                return false;
            }
        }
        return true;
    }

    /**
     * counter ASCII character as one, otherwise two
     *
     * @param str
     * @return count
     */
    public static int counterChars(String str) {
        // return
        if (TextUtils.isEmpty(str)) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < str.length(); i++) {
            int tmp = (int) str.charAt(i);
            if (tmp > 0 && tmp < 127) {
                count += 1;
            } else {
                count += 2;
            }
        }
        return count;
    }

    /**
     * 获取32位uuid
     *
     * @return
     */
    public static String get32UUID() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String get36UUID() {
        UUID uuid = UUID.randomUUID();
        String uniqueId = uuid.toString();
        return uniqueId;
    }


    public static String StringFilter(String str) throws PatternSyntaxException {
        String result = "";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length(); i++) {
            if (StringUtils.isEmojiCharacter(str.charAt(i))) {
                sb.append(str.charAt(i));
            }
        }
        result = sb.toString();
        return result;
    }

    public static boolean isEmojiCharacter(char codePoint) {
        return (codePoint == 0x0) || (codePoint == 0x9) || (codePoint == 0xA) ||
                (codePoint == 0xD) || ((codePoint >= 0x20) && (codePoint <= 0xD7FF)) ||
                ((codePoint >= 0xE000) && (codePoint <= 0xFFFD)) || ((codePoint >= 0x10000)
                && (codePoint <= 0x10FFFF));
    }

    /***
     * 判断跳转H5还是打开原生页面
     * @param A
     * @return
     */
    public static Map<String, String> IsHttpReturn(String A) {
        Map<String, String> map = new HashMap<>();
        if (A.contains("http://") || A.contains("https://")) { //表明为跳转url
            map.put("jump_type", "url");
            if (A.contains("experts")) {//判断跳转那种类型的H5页面
                if (A.contains("search")) {
                    map.put("url_page", "experts_search");//专家搜索
                } else {
                    map.put("url_page", "experts");//专家主页
                }
            } else if (A.contains("ct/list")) {//免费体验
                map.put("url_page", "free_trial");
            } else if (A.contains("ceshi/detail") || A.contains("test/detail")) { //测试
                map.put("url_page", "test_detail");
            } else if (A.contains("ceshi/result") || A.contains("test/result")) { //测试
                map.put("url_page", "test_result");
            } else if (A.contains("ceshi/")) { //测试
                map.put("url_page", "test");
            } else {
                map.put("url_page", "other");//其他的
            }
            map.put("url", A);
        } else if (A.contains("ydl://")) {//表明跳转为原生
            map.put("jump_type", "native");
            String native_page = A.substring(6, A.indexOf("?"));
            map.put("native_page", native_page);
            map.putAll(TemporaryUtils.getUrlParams(A));

        } else {
            map.put("jump_type", "no");
        }

        return map;
    }

    /**
     * 对字符串进行MD5加密</br>
     * 如果返回为空，则表示加密失败
     *
     * @param s
     * @return
     */
    public static String md5(String s) {
        char hexDigits[] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9',
                'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            byte[] strTemp = s.getBytes("utf-8");
            // 使用MD5创建MessageDigest对象
            MessageDigest mdTemp = MessageDigest.getInstance("MD5");
            mdTemp.update(strTemp);
            byte[] md = mdTemp.digest();
            int j = md.length;
            char str[] = new char[j * 2];
            int k = 0;
            for (int i = 0; i < j; i++) {
                byte b = md[i];
                // 将每个数(int)b进行双字节加密
                str[k++] = hexDigits[b >> 4 & 0xf];
                str[k++] = hexDigits[b & 0xf];
            }
            return new String(str);
        } catch (Exception e) {
            return null;
        }
    }

    public static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }


    /**
     * 判断传入时间与当前时间是否是同一天
     *
     * @param last 需要被比较的时间
     * @return
     */
    public static boolean compareTime(String last) {
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");//如2016-08-10
        if (TextUtils.isEmpty(last) || TextUtils.equals("0", last)) {
            return false;
        } else {
            long time = System.currentTimeMillis();
            Date date = new Date();
            date.setTime(time);
            String nowTime = simpleFormat.format(date);
            Date lastDate = new Date();
            lastDate.setTime(Long.valueOf(last));
            String lastTime = simpleFormat.format(lastDate);
            if (TextUtils.equals(lastTime.substring(0, 10), nowTime.substring(0, 10))) {
                //是同一天
                return true;
            } else {
                //不是同一天
                return false;
            }
        }
    }

    /**
     * 保留两位小数
     */
    public static String save2Double(double value){
        String str = "--";
        try {
            str = String.format("%.2f",value).toString();
        }catch (Exception e){
            e.printStackTrace();
        }
        return str;
    }

    /**
     * 字符串以逗号分割转List
     */
    public static List<String> strToList(String str){
        List list = new ArrayList();
        if (TextUtils.isEmpty(str)){
            return list;
        }
        String[] ss = str.split("\\|");
        return Arrays.asList(ss);
    }
}
