package com.ydl.ydlcommon.utils;

import android.net.Uri;
import android.text.TextUtils;
import com.ydl.ydlcommon.data.http.GsonProvider;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Created by haorui on 2019/4/9.
 * Des:
 */
public class URLUtils {

    public static Map<String, String> queryStr2Map(String url){
       URI uri  =  URI.create(url);
        Map<String, String> query_pairs = new LinkedHashMap<String, String>();
        String query = uri.getQuery();
        String[] pairs = query.split("&");
        for (String pair : pairs) {
            int idx = pair.indexOf("=");
            query_pairs.put(pair.substring(0, idx), pair.substring(idx + 1));
        }
        return query_pairs;
    }

    public static String map2QueryStr(Map<String, String> map) {
        StringBuffer sb = new StringBuffer();
        if (map.size() > 0) {
            for (String key : map.keySet()) {
                sb.append(key + "=");
                if (StringUtils.isEmpty(map.get(key))) {
                    sb.append("&");
                } else {
                    String value = map.get(key);
                    try {
                        value = URLEncoder.encode(value, "UTF-8");
                    } catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    sb.append(value + "&");
                }
            }
        }
        return sb.toString();
    }

    //url追加参数
    public static String appendParmas(String url1,String key,String value){
        if (TextUtils.isEmpty(url1) || TextUtils.isEmpty(key) || TextUtils.isEmpty(value)){
            return "";
        }
        String url = url1;

        try {
            Uri uri = Uri.parse(url1);
            if (uri.getScheme().equals("ydl-user")){
                //统一路由格式
                String json = uri.getQueryParameter("params");
                if (!TextUtils.isEmpty(json)){
                    LinkedHashMap linkedHashMap = GsonProvider.INSTANCE.getGson().fromJson(json,LinkedHashMap.class);
                    String urluu = (String) linkedHashMap.get("url");
                    //加入参数
                    urluu = urlAppendParam(urluu,key,value);
                    linkedHashMap.put("url",urluu);
                    //组装新的url
                    String params = GsonProvider.INSTANCE.getGson().toJson(linkedHashMap);
                    params = URLEncoder.encode(params,"UTF-8");
                    String[] sss = url.split("\\?");
                    url = sss[0]+"?params="+params;
                }else {
                    //没有params，则表示url格式有误，不处理
                }

            }else {
                //非统一路由格式
                //加入参数
                url = urlAppendParam(url,key,value);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        return url;
    }

    private static String urlAppendParam(String urluu,String key,String value){
        if (TextUtils.isEmpty(urluu) || TextUtils.isEmpty(key) || TextUtils.isEmpty(value)){
            return "";
        }
        if (urluu.contains("?")){
            String[] ss = urluu.split("\\?");
            if (TextUtils.isEmpty(ss[1])){
                urluu+=key+"="+value;
            }else {
                urluu+="&"+key+"="+value;
            }
        }else {
            urluu+="?"+key+"="+value;
        }
        return urluu;
    }

}
