package com.ydl.ydlcommon.utils;

import android.app.Application;
import android.util.Base64;
import android.util.Log;

import com.ydl.ydlcommon.base.BaseApp;
import com.ydl.ydlcommon.utils.remind.ToastHelper;
import com.yidianling.protector.AppProtectorLib;

import java.util.concurrent.TimeUnit;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;

/**
 * Created by haorui on 2019/7/10.
 * Des:应用防护措施
 */
public class YDLAppProtector {

    //"检测到多开操作，应用即将退出"
    private static final String hint_1 =  "5qOA5rWL5Yiw5aSa5byA5pON5L2c77yM5bqU55So5Y2z5bCG6YCA5Ye6";
    //"检测到模拟器运行，应用即将退出"
    private static final String hint_2 =  "5qOA5rWL5Yiw5qih5ouf5Zmo6L+Q6KGM77yM5bqU55So5Y2z5bCG6YCA5Ye6";
    //"检测到调试操作，应用即将退出"
    private static final String hint_3 =  "5qOA5rWL5Yiw6LCD6K+V5pON5L2c77yM5bqU55So5Y2z5bCG6YCA5Ye6";
    //"检测到签名文件异常，应用即将退出"
    private static final String hint_4 =  "5qOA5rWL5Yiw562+5ZCN5paH5Lu25byC5bi477yM5bqU55So5Y2z5bCG6YCA5Ye6";
    //"该设备已Root，请注意支付安全"
    private static final String hint_5 =  "6K+l6K6+5aSH5beyUm9vdO+8jOivt+azqOaEj+aUr+S7mOWuieWFqA==";
    //"检测到XPosed框架开启，正在尝试关闭"
    private static final String hint_6 =  "5qOA5rWL5YiwWFBvc2Vk5qGG5p625byA5ZCv77yM5q2j5Zyo5bCd6K+V5YWz6Zet";


    public static void init() {

        Application app = BaseApp.Companion.getApp();

        //检查应用多开
        //handleDetect(AppProtectorLib.checkIsRunningInVirtualApk(app.getPackageName(),null),true,getHint(hint_1));

        //模拟器检测  获取传感器不合规
//        handleDetect(AppProtectorLib.checkIsRunningInEmulator(app,null),true,getHint(hint_2));

        //反调试方案 - 检测app是否为debug版本/检测是否有附加调试进程
        //handleDetect(AppProtectorLib.checkIsDebug(app),true,getHint(hint_3));

        //反调试方案 - 检测调试端口是否被占用，23946：IDA 中 android_server 默认端口
        //handleDetect(SecurityCheckUtil.getSingleInstance().isLocalPortUsing(23946),true,"暂不支持调试应用，即将退出");

        //反调试方案 - 轮询traceid检测
        //AppProtectorLib.checkIsBeingTracedByC();

        //检查签名是否一致
        handleDetect(!AppProtectorLib.checkSignature(app),true,getHint(hint_4));

        //检查Root权限
        handleDetect(AppProtectorLib.checkIsRoot(),false,getHint(hint_5));

        //检查Xposed框架并自动关闭Xposed
        if(AppProtectorLib.checkIsXposedExist()) {
            ToastHelper.Companion.show(getHint(hint_6));
            AppProtectorLib.checkXposedExistAndDisableIt();
        }


    }

    private static void handleDetect(boolean result, boolean isExit, String hintText){
        if(result) {
            ToastHelper.Companion.show(hintText);
            Log.e(YDLAppProtector.class.getSimpleName()," >>>>>> "+hintText+" <<<<< ");
            if(isExit) {
                Observable.timer(1000, TimeUnit.MILLISECONDS)
                        .observeOn(AndroidSchedulers.mainThread())
                        .subscribe(aLong -> {
                            System.exit(0);
                        });
            }
        }
    }

    private static String getHint(String str){
        byte[] data = Base64.decode(str, Base64.DEFAULT);
        return new String(data);
    }
}
