package com.ydl.ydlcommon.utils

import io.reactivex.Observable
import io.reactivex.disposables.Disposable
import java.util.concurrent.TimeUnit

/**
 * @author yuanwai
 * @描述:壹点灵定时任务
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/9/12
 */
class YDLTimer{
    companion object {

        private var timeDisposable: Disposable? = null
        /**
         * 启动任务
         */
        fun start(asyncObjecyer: AsyncObjecyer, time : Long) {
            timeDisposable = Observable.timer(time, TimeUnit.SECONDS).subscribe { asyncObjecyer.doAsyncAction() }
        }

        /**
         * 解除任务
         */
        fun stop(){
            if (timeDisposable != null && !timeDisposable!!.isDisposed) {
                timeDisposable!!.dispose()
            }
        }
    }

    interface AsyncObjecyer {
        fun doAsyncAction()
    }
}