package com.ydl.ydlcommon.utils.extend

import android.content.res.Resources
import android.text.TextUtils

inline fun <T1, T2> ifNotNull(value1: T1?, value2: T2?, bothNotNull: (t1: T1, t2: T2) -> Unit) {
    if (value1 != null && value2 != null) {
        bothNotNull(value1, value2)
    }
}

/**
 *  Map 扩展
 */
fun <K, V> Map<K, V>?.getIntOr(key: K, default: Int = 0): Int {
    return if (this != null) ((this[key] as? Int)?: default) else default
}
fun <K, V> Map<K, V>?.getStringOr(key: K, default: String = ""): String {
    return if (this != null) ((this[key] as? String)?: default) else default
}

fun Any?.asString(default: String = ""): String {
    return (this as? String) ?: default
}

inline fun String?.notEmpty(block: (String) -> Unit) {
    if (this != null && this.isNotEmpty()) block(this)
}

fun String?.notEqual(other: String?): Boolean = !TextUtils.equals(this, other)

inline fun String?.notNullNotEmpty(block: (String) -> Unit) {
    if (this != null && this.isNotEmpty() && this.notEqual("null")) block(this)
}

fun Number?.initZero(): Number = this ?: 0 as Number

// ----------------  ⬇️ dp px 互转 ⬇️  ------------------

val Float.dp: Float
    get() = this * Resources.getSystem().displayMetrics.density

val Int.dp: Float
    get() = (this * Resources.getSystem().displayMetrics.density)

// ----------------  ⬆️ dp px 互转 ️⬆️  -----------------
