package com.ydl.ydlcommon.view

import android.content.Context
import android.view.View
import android.widget.ProgressBar
import android.widget.RelativeLayout
import android.widget.TextView
import com.ydl.ydlcommon.R

/**
 * 配合listview  上啦加载更多状态显示view
 * Created by hgw on 2017/7/2.
 */
class FootViewLoadMore : RelativeLayout{

    private var circle_progress : ProgressBar? =null

    private var tv_content : TextView? =null

    //加载中文字
    private var loadingStr = "加载中..."
    //加载完毕文字
    private var loadFinishStr  = "没有更多了"
    //
    private var loadErrorStr = "加载错误，请重试"

    constructor(context: Context) : super(context){
        View.inflate(context, R.layout.platform_view_footview_loadmore,this)

        initView()
    }

    private fun initView(){
        circle_progress = findViewById(R.id.circle_progress) as ProgressBar
        tv_content = findViewById(R.id.tv_content) as TextView
    }

    //设置显示文字
    fun setLoadingText(str : String){
        loadingStr = str
        tv_content?.setText(str)
    }

    //加载完成文字
    fun setLoadFinished(str : String){
        loadFinishStr = str
        tv_content?.setText(str)
    }

    //加载出错
    fun onError(){
        circle_progress?.visibility = View.GONE
        tv_content?.visibility = View.VISIBLE
        tv_content?.setText(loadErrorStr)
    }

    //加载完成 没有更多了
    fun onLoading(){
        //加载中
        circle_progress?.visibility = View.VISIBLE
        tv_content?.visibility = View.VISIBLE
        tv_content?.setText(loadingStr)
    }

    //加载完成
    fun onFinish(){
        //加载完毕
        circle_progress?.visibility = View.GONE
        tv_content?.visibility = View.VISIBLE
        tv_content?.setText(loadFinishStr)
    }
}
