package com.ydl.ydlcommon.view

import android.content.Context
import android.view.View
import android.widget.LinearLayout
import android.widget.RelativeLayout
import android.widget.TextView
import com.ydl.ydlcommon.R

/**
 * 配合list 使用的footview
 * Created by harvie on 2017/6/28 0028.
 */
class FootViewMore : RelativeLayout {

    var lin_body: LinearLayout? = null

    var text_null: TextView? = null

    var text_more: TextView? = null

    constructor(context: Context) : super(context) {
        View.inflate(context, R.layout.platform_view_foot_view_more, this)

        initView()
    }

    fun initView() {
        lin_body = findViewById<LinearLayout>(R.id.lin_body)
        text_more = findViewById<TextView>(R.id.text_more)
        text_null = findViewById<TextView>(R.id.text_null)
    }

    fun setMoreClickListener(lis: OnClickListener) {
        text_more?.setOnClickListener(lis)
    }

    //设置空内容提示
    fun setnullLayout(boolean: Boolean) {
        lin_body?.visibility = View.VISIBLE
        if (boolean) {
            //显示空提示布局
            text_null?.visibility = View.VISIBLE
            text_more?.visibility = View.GONE
        } else {
            //展示需要的布局
            text_null?.visibility = View.GONE
            text_more?.visibility = View.VISIBLE
        }
    }

    //隐藏布局
    fun hideLayout() {
        lin_body?.visibility = View.GONE
    }
}