package com.ydl.ydlcommon.view;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.Log;

/**
 * Created by jiucheng on 2018/5/15.
 * 功能：手机号输入框--自动添加空格  131 1234 5678 {@link #setPhoneText(String phone)}
 * 获取输入框内容时，自动取消空格 {@link #getTextContent()}
 */

public class PhoneEditText extends androidx.appcompat.widget.AppCompatEditText {
    public PhoneEditText(Context context) {
        super(context);
        init(context);
    }

    public PhoneEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
    }

    public PhoneEditText(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    private void init(Context context) {
        this.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {
                Log.i("tetetset", s + "--" + String.valueOf(start) + "--" +  String.valueOf(before) + "--" +  String.valueOf(count));
                if (s == null || s.length() == 0) return;
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < s.length(); i++) {
                    if (i != 3 && i != 8 && s.charAt(i) == ' ') {
                        continue;
                    } else {
                        sb.append(s.charAt(i));
                        if ((sb.length() == 4 || sb.length() == 9) && sb.charAt(sb.length() - 1) != ' ') {
                            sb.insert(sb.length() - 1, ' ');
                        }
                    }
                }
                if (!sb.toString().equals(s.toString())) {
                    int index = start + 1;
                    if (start < sb.length() - 1 && sb.charAt(start) == ' ') {
                        if (before == 0) {
                            index++;
                        } else {
                            index--;
                        }
                    } else {
                        if (before == 1) {
                            index--;
                        }
                    }
                    setText(sb.toString());
                    if (index > sb.length())
                        index = sb.length();
                    setSelection(index);
                }
            }

            @Override
            public void afterTextChanged(Editable s) {
                if (listener != null) {
                    listener.setOnTextChangedListener(s);
                }
            }
        });
    }

    OnAfterTextChangedListener listener;

    public void setListener(OnAfterTextChangedListener listener) {
        this.listener = listener;
    }

    public interface OnAfterTextChangedListener {
        void setOnTextChangedListener(Editable s);
    }

    /**
     * 获取输入框内容，输入框中的空格
     *
     * @return 不带空格的String
     */
    public String getTextContent() {
        String content = getText().toString().trim();
        return content.replace(" ", "");
    }

    /**
     * 将电话号码填入输入框，并增加空客
     *
     * @param phone 电话号码
     */
    public void setPhoneText(String phone) {
        if (phone.length() == 11) {
            StringBuffer sb = new StringBuffer(phone);
            sb.insert(7, " ");
            sb.insert(3, " ");
            setText(sb.toString());
            setSelection(sb.toString().length());
        }
    }
}
