package com.ydl.ydlcommon.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.View;

import com.ydl.ydlcommon.R;

/**
 * @author jiucheng
 * @描述: 进度view
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/11/1
 */
public class ProgressView extends View {
    private TextPaint mTextPaint;
    private Paint mProgressPaint;
    private int progressColor;//进度条颜色
    private int progressBackColor = Color.WHITE;//背景颜色
    private float textSize;
    private int textColor;
    private float progressWidth;//圆的宽度
    private Paint.FontMetrics fm;
    private Rect rect;//字体的大小
    private float progress = 1;
    private String textContent = "0%";//字体内容
    private float viewWidth, viewHeight;//View的宽高
    private boolean isDrawText = false;//文字是否需要绘制
    /**
     * 文本X坐标
     */
    private float textX;
    /**
     * 文本Y坐标
     */
    private float textY;

    public ProgressView(Context context) {
        super(context);
        init(null, 0);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        init(attrs, 0);
    }

    public ProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(attrs, defStyleAttr);
    }

    @RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
    public ProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.Platform_ProgressView, defStyleAttr, 0);
        progressColor = typedArray.getColor(R.styleable.Platform_ProgressView_pa_progressColor, Color.GREEN);
        progressBackColor = typedArray.getColor(R.styleable.Platform_ProgressView_pa_progressBackColor, Color.WHITE);
        progressWidth = typedArray.getDimensionPixelSize(R.styleable.Platform_ProgressView_pa_progressWidth, 20);
        textSize = typedArray.getDimensionPixelSize(R.styleable.Platform_ProgressView_pa_textSize, (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_SP, 20, getResources().getDisplayMetrics()));
        textColor = typedArray.getColor(R.styleable.Platform_ProgressView_pa_textColor, Color.BLACK);

        mTextPaint = new TextPaint();
        mTextPaint.setAntiAlias(true);
        mTextPaint.setColor(textColor);
        mTextPaint.setTextSize(textSize);
        mTextPaint.setFlags(Paint.ANTI_ALIAS_FLAG);
        mTextPaint.setTextAlign(Paint.Align.LEFT);
        rect = new Rect();

        mProgressPaint = new Paint();
        mProgressPaint.setAntiAlias(true);

        mProgressPaint.setStyle(Paint.Style.STROKE);
        mProgressPaint.setStrokeWidth(progressWidth);
        mProgressPaint.setColor(progressBackColor);
    }


    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (isDrawText) {
            //绘制文字
            setTextLocation();
            canvas.drawText(textContent, textX, textY, mTextPaint);
        }

        //绘制进度条
        float centerX = getWidth() / 2;
        float centerY = getHeight() / 2;
        float radius = centerX - getPaddingLeft() - progressWidth;
//        canvas.drawCircle(centerX, centerY, radius, mProgressPaint);

//        mProgressPaint.setColor(progressColor);
        RectF rf = new RectF(centerX - radius, centerX - radius, centerX + radius, centerX + radius);

        canvas.drawArc(rf, -90, progress - 360f, false, mProgressPaint);
    }

    private void setTextLocation() {
        fm = mTextPaint.getFontMetrics();
        mTextPaint.getTextBounds(textContent, 0, textContent.length(), rect);
        float numTextWidth = rect.width();
        float textCenterVerticalBaselineY = viewHeight / 2 - fm.descent + (fm.descent - fm.ascent) / 2;
        textX = viewWidth / 2 - numTextWidth / 2;
        textY = textCenterVerticalBaselineY;
    }


    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        setMeasuredDimension(measure_wh(widthMeasureSpec, 0), measure_wh(heightMeasureSpec, 1));
    }

    private int measure_wh(int measureSpec, int type) {
        int result = 0;
        int specMode = MeasureSpec.getMode(measureSpec);
        int specSize = MeasureSpec.getSize(measureSpec);
        if (specMode == MeasureSpec.EXACTLY) {
            result = specSize;
        } else {
            result = 300;
        }
        if (type == 0) {
            viewWidth = result;
        } else {
            viewHeight = result;
        }
        return result;
    }

    public void setProgress(float progress) {
        if (progress <= 100f) {
            textContent = progress + "%";
            this.progress = (float) (progress * 3.6);
            invalidate();
        }
    }

    /**
     * 是否显示文字
     *
     * @param isDrawText
     */
    public void setIsDrawText(boolean isDrawText) {
        this.isDrawText = isDrawText;
    }
}
