package com.ydl.ydlcommon.view

import android.graphics.Rect
import androidx.recyclerview.widget.RecyclerView
import android.view.View


/**
 * RecyclerView 添加空白
 * Created by zqk on 17-9-20.
 */
class SpaceItemDecorator2(val space: Int, val spanCount: Int = 1) : RecyclerView.ItemDecoration() {

    override fun getItemOffsets(outRect: Rect, view: View,
                                parent: RecyclerView, state: RecyclerView.State) {
        outRect.left = space
        outRect.top = space
        outRect.right = space
        outRect.bottom = space

        // Add top margin only for the first item to avoid double space between items
//        if (parent.getChildAdapterPosition(view) < spanCount) {
//            outRect.top = space
//        }
    }
}