package com.ydl.ydlcommon.view

import android.content.Context
import android.graphics.Color
import android.graphics.Rect
import android.text.TextUtils
import android.util.AttributeSet
import android.util.TypedValue
import android.view.View
import android.view.ViewGroup
import android.widget.LinearLayout
import android.widget.TextView
import com.ydl.ydlcommon.R
import com.yidianling.common.tools.RxDeviceTool
import com.yidianling.common.tools.RxImageTool


/**
 * @author yuanWai
 * @描述:首页热线倾诉模块--标签View
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2019/1/24
 */
class TagView : LinearLayout {
    //数据缓存
    private var mCacheList: MutableList<String>? = null
    //标签的实际宽度
    private var tagViewWidth: Int = 0
    //标签的最大宽度
    private var tagViewMaxWidth: Int = 0

    private var dp19: Int = 0
    private var dp5: Int = 0
    //默认字体大小
    private var defaultTextSize = 10f
    //默认字体颜色
    private var defaultTextColor = "#444444"
    //默认字体背景
    private var defaultTextBg = R.drawable.platform_tag_bg

    init {
        tagViewMaxWidth = RxDeviceTool.getScreenWidth(context) - RxImageTool.dip2px(159f)
        dp19 = RxImageTool.dip2px(19f)
        dp5 = RxImageTool.dip2px(5f)
    }

    constructor(context: Context) : super(context) {
        initView()
    }

    constructor(context: Context, attributeSet: AttributeSet) : super(context, attributeSet) {
        initView()
    }

    private fun initView() {
        orientation = HORIZONTAL
    }

    /**
     * 设置倾诉最大宽度
     * 倾诉和咨询模块使用的宽度是不一样的
     */
    fun setConfideWidth(){
        tagViewMaxWidth = RxDeviceTool.getScreenWidth(context) - RxImageTool.dip2px(164f)
    }

    /**
     * 设置数据
     */
    fun initData(list: MutableList<String>?) {
        if (null == list || list.isEmpty()) {
            visibility = View.INVISIBLE
            return
        }
        visibility = View.VISIBLE
        //创建View 如果缓存数相同 则不需要重新创建
        if (null == mCacheList || mCacheList!!.size != list.size) {
            //需要重置一下 不然添加不进去
            tagViewWidth = 0
            if (null == mCacheList) {
                mCacheList = ArrayList()
            } else {
                mCacheList?.clear()
            }
            mCacheList?.addAll(list)
            removeAllViews()
            for (i in list.indices) {
                //太多显示不全
                if (i>2){
                    continue
                }
                bindView()
                //这块的非主流操作是因为我要取textView来计算文字的宽度
                //但是第一次判断要在view添加上 才能取到 故放在了创建view的下面
                //所以 里面有把这个多余的view给remove掉，就酱
                if (isMaxWidth(getChildAt(i) as TextView, list[i])) {
                    removeViewAt(i)
                    break
                }
            }
        }
        //填充数据
        for (i in list.indices) {
            bindData(i, list[i])
        }
    }

    /**
     * 创建标签
     */
    private fun bindView() {
        val tag = TextView(context)
        tag.setTextSize(TypedValue.COMPLEX_UNIT_SP, defaultTextSize)
        tag.setTextColor(Color.parseColor(defaultTextColor))
        tag.setBackgroundResource(defaultTextBg)
        val params = LinearLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT)
        params.setMargins(0, 0, dp5, 0)
        tag.layoutParams = params
        addView(tag)
    }

    /**
     * 填充数据
     */
    private fun bindData(index: Int, tagName: String?) {
        if (getChildAt(index) is TextView) {
            (getChildAt(index) as TextView).text = tagName
        }
    }

    /**
     * 是否超过了最大宽度
     */
    private fun isMaxWidth(textView: TextView, tagName: String?): Boolean {
        var with = 0
        if (!TextUtils.isEmpty(tagName)) {
            with = getTextContentWidth(textView, tagName!!) + dp19
        }
        tagViewWidth += with
        return tagViewWidth >= tagViewMaxWidth
    }

    /**
     * 设置字体大小
     */
    fun setDefaultTextSize(defaultTextSize: Float) {
        this.defaultTextSize = defaultTextSize
    }

    /**
     * 设置字体颜色
     */
    fun setDefaultTextColor(color: String) {
        this.defaultTextColor = defaultTextColor
    }

    /**
     * 设置字体背景
     */
    fun setDefaultTextBg(defaultTextBg: Int) {
        this.defaultTextBg = defaultTextBg
    }

    private fun getTextContentWidth(textView: TextView, text: String): Int {
        val rect = Rect()
        textView.paint.getTextBounds(text, 0, text.length, rect)
        return rect.width()//文字宽
    }
}