package com.ydl.ydlcommon.view.banner;

import android.content.Context;
import android.widget.ImageView;

import com.ydl.ydl_image.config.ISimpleImageOpConfig;
import com.ydl.ydl_image.config.SimpleImageOpConfiger;
import com.ydl.ydl_image.manager.YDLImageCacheManager;
import com.ydl.ydlcommon.view.banner.loader.ImageLoader;

/**
 * @author jiucheng
 * @描述:
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/8/7
 */

public class GlideImageLoader extends ImageLoader {
    private int placeholderImage;//加载过程中的中间页面
    private int radius = 0;

    public GlideImageLoader() {
    }

    public GlideImageLoader(int placeholderImage) {
        this.placeholderImage = placeholderImage;
    }

    public GlideImageLoader(int placeholderImage, int radius) {
        this.placeholderImage = placeholderImage;
        this.radius = radius;
    }

    @Override
    public void displayImage(Context context, Object path, ImageView imageView) {

        if (placeholderImage > 0) {
            if (path instanceof String) {
                SimpleImageOpConfiger sp = new SimpleImageOpConfiger();
                sp.loadingPic = placeholderImage;
                sp.scaleType = ISimpleImageOpConfig.CENTER_CROP;
                sp.transform = ISimpleImageOpConfig.TRANSFORM_ROUND;
                sp.radius = radius;
                sp.transition = false;
                YDLImageCacheManager.showImage(context, (String) path, imageView, imageView.getWidth(), imageView.getHeight(), sp);
            }
        } else {
            if (path instanceof String) {
                if (imageView != null) {
                    imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                }
                YDLImageCacheManager.showImage(context, (String) path, imageView, imageView.getWidth());
            }
        }
    }
}
