package com.ydl.ydlcommon.view.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.GradientDrawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;

import com.ydl.ydlcommon.R;
import com.ydl.ydlcommon.utils.DisplayUtils;


/**
 * 通用dialog
 * a,支持单张图片显示
 * b,支持单双按钮显示
 * c,支持title
 * d,支持message
 * Created by harvie on 2016/12/9.
 */
public class CommonDialog extends Dialog {

    //是否可以点击对话框外部
    private Context context; //上下文对象

    private TextView title_tv;
    private ImageView imageCenter;
    private TextView message_tv;
    private Button left_btn;//左边取消按钮
    private View view_vertical_line;//按钮之间的分割线
    private Button right_btn;//右边确定按钮

    public static CommonDialog create(Context context) {
        return new CommonDialog(context);
    }

    public CommonDialog(Context context) {
        super(context, R.style.platform_normaldialog_style);
        this.context = context;

        View v = LayoutInflater.from(context).inflate(R.layout.platform_dialog_common_layout, null);

        title_tv =  v.findViewById(R.id.title);
        imageCenter =  v.findViewById(R.id.img_tip);
        message_tv = v.findViewById(R.id.message);
        left_btn =  v.findViewById(R.id.cancel_btn);
        view_vertical_line = v.findViewById(R.id.view_vertical_line);
        right_btn =  v.findViewById(R.id.confirm_btn);

        setContentView(v, new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
    }

    public CommonDialog(Context context, int theme) {
        super(context, R.style.platform_normaldialog_style);
        this.context = context;
    }

    /**
     * 设置左下角按钮的隐藏与显示
     *
     * @return 当前CommonDialog本身
     */
    public CommonDialog setCancleIsVisibility(int visibility) {

        if (left_btn != null) {
            left_btn.setVisibility(visibility);
        }
        return this;
    }

    /*设置对话框信息*/
    public CommonDialog setMessage(String message) {
        if (message != null) {
            message_tv.setText(message);
        }
        return this;
    }

    /**
     * 设置message文本抖动动画
     */
    public CommonDialog setMessageShake(boolean isShake) {
        if (isShake) {
            message_tv.startAnimation(AnimationUtils.loadAnimation(getContext(), R.anim.platform_shake_smail));
        }
        return this;
    }

    /**
     * 设置信息颜色
     */
    public CommonDialog setMessageColor(int resColor) {
        message_tv.setTextColor(getContext().getResources().getColor(resColor));
        return this;
    }

    /**
     * Set the Dialog title from String
     *
     * @param title  标题
     * @return 当前CommonDialog本身
     */
    public CommonDialog setTitle(String title) {
        if ("".equals(title) || title == null) {
            title_tv.setVisibility(View.GONE);
        } else {
            title_tv.setVisibility(View.VISIBLE);
            title_tv.setText(title);
            title_tv.getPaint().setFakeBoldText(true);//仿粗体
        }
        return this;
    }

    /**
     * 设置描述
     */
    public CommonDialog setMessageTextGravity(int gravity) {
        message_tv.setGravity(gravity);
        return this;
    }

    /**
     * 设置标题颜色
     */
    public CommonDialog setTitle_color(int res_color) {
        title_tv.setTextColor(getContext().getResources().getColor(res_color));
        return this;
    }

    //设置消息颜色
    public CommonDialog setContent_color(int content_color) {
        message_tv.setTextColor(getContext().getResources().getColor(content_color));
        return this;
    }

    /**
     * 设置左侧按钮文字颜色
     */
    public CommonDialog setLeftButton_color(int left_color) {
        left_btn.setTextColor(getContext().getResources().getColor(left_color));
        return this;
    }

    /**
     * 设置右侧按钮文字颜色
     */
    public CommonDialog setRightButton_color(int right_color) {
        right_btn.setTextColor(getContext().getResources().getColor(right_color));
        return this;
    }

    /**
     * 设置左侧按钮背景
     */
    public CommonDialog setLeftButtonBackgroundColor(int left_background_color) {
        GradientDrawable gd = new GradientDrawable();
        gd.setCornerRadii(new float[]{0f, 0f, 0f, 0f, 0f, 0f, (float) DisplayUtils.dp2px(getContext(), 10), (float) DisplayUtils.dp2px(getContext(), 10)});
        gd.setColor(getContext().getResources().getColor(left_background_color));
        left_btn.setBackground(gd);
        return this;
    }

    /**
     * 设置右侧按钮背景
     */
    public CommonDialog setRightButtonBackgroundColor(int right_background_color) {
        GradientDrawable gd = new GradientDrawable();
        gd.setCornerRadii(new float[]{0f, 0f, 0f, 0f, (float) DisplayUtils.dp2px(getContext(), 10), (float) DisplayUtils.dp2px(getContext(), 10), 0f, 0f});
        gd.setColor(getContext().getResources().getColor(right_background_color));
        right_btn.setBackground(gd);
        return this;
    }

    public CommonDialog setCancelAble(boolean flag) {
        setCancelable(flag);
        setCanceledOnTouchOutside(flag);
        return this;
    }

    /**
     * 设置中间图片资源
     */
    public CommonDialog setImageCenter(int resId) {
        imageCenter.setImageResource(resId);
        imageCenter.setVisibility(View.VISIBLE);
        return this;
    }

    public CommonDialog setRightClick(String confirm_btnText, final View.OnClickListener listener) {
        right_btn.setText(confirm_btnText);
        right_btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (listener != null) {
                    listener.onClick(v);
                }
            }
        });
        right_btn.setVisibility(View.VISIBLE);
        if (left_btn.getVisibility() == View.GONE) {
            view_vertical_line.setVisibility(View.GONE);
        } else {
            view_vertical_line.setVisibility(View.VISIBLE);
        }
        return this;
    }

    public CommonDialog setLeftOnclick(String cancel_btnText, final View.OnClickListener listener) {
        left_btn.setText(cancel_btnText);
        left_btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (listener != null) {
                    listener.onClick(v);
                }
            }
        });
        left_btn.setVisibility(View.VISIBLE);
        if (right_btn.getVisibility() == View.GONE) {
            view_vertical_line.setVisibility(View.GONE);
        } else {
            view_vertical_line.setVisibility(View.VISIBLE);
        }
        return this;
    }

    public CommonDialog setMessageOnclick(final View.OnClickListener listener) {
        message_tv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                dismiss();
                if (listener != null) {
                    listener.onClick(v);
                }
            }
        });
        return this;
    }

    public CommonDialog setOnDismiss(final OnDismissListener listener) {
        this.setOnDismissListener(new OnDismissListener() {
            @Override
            public void onDismiss(DialogInterface dialog) {
                context = null;
                listener.onDismiss(dialog);
            }
        });
        return this;
    }

    @Override
    public void show() {
        if (null == context) {
            return;
        }
        if (context instanceof Activity) {
            if (((Activity) context).isFinishing()) {
                return;
            }
        }
        super.show();
    }
}
