package com.ydl.ydlcommon.view.dialog

import android.app.Dialog
import android.content.Context
import android.os.Bundle
import android.view.Gravity
import android.view.View
import android.view.WindowManager
import com.ydl.ydlcommon.R
import com.ydl.ydlcommon.router.YdlCommonOut
import kotlinx.android.synthetic.main.platform_ydl_common_dialog_layout.*

class YDLCommonDialog: Dialog {

    private var mContext: Context? = null
    private var mListener: OnYDLCommonDialogListener? = null

    private var hasTitle = true // 默认为有标题弹窗
    private var mTitle: String = ""
    private var mDesc: String = ""
    private var mLeftText: String = ""
    private var mRightText: String = ""

    constructor(context: Context, listener: OnYDLCommonDialogListener?): super(context, R.style.platform_dialog_default_style) {
        mContext = context
        mListener = listener
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.platform_ydl_common_dialog_layout)

        val params = window.attributes
        params.width = WindowManager.LayoutParams.MATCH_PARENT
        params.height = WindowManager.LayoutParams.WRAP_CONTENT
        window.setGravity(Gravity.CENTER)
        window.attributes = params

        if (hasTitle) {
            ydl_common_dialog_title.visibility = View.VISIBLE
            ydl_common_dialog_desc.visibility = View.VISIBLE
            ydl_common_dialog_title.text = mTitle
            ydl_common_dialog_desc.text = mDesc
            ydl_common_dialog_null_title_desc.visibility = View.GONE
        }else {
            ydl_common_dialog_title.visibility = View.GONE
            ydl_common_dialog_desc.visibility = View.GONE
            ydl_common_dialog_null_title_desc.visibility = View.VISIBLE
            ydl_common_dialog_null_title_desc.text = mDesc
        }
        ydl_common_dialog_cancel.text = mLeftText
        ydl_common_dialog_sure.text = mRightText

        val packageName = YdlCommonOut.getApp().packageName
        if (packageName == "com.cxzapp.yidianling") {
            ydl_common_dialog_sure.setBackgroundResource(R.drawable.platform_ydl_common_dialog_sure_btn_ydl_bg)
        }else if (packageName == "com.cxzapp.xinlizixun"){
            ydl_common_dialog_sure.setBackgroundResource(R.drawable.platform_ydl_common_dialog_sure_btn_xlzx_bg)
        }

        ydl_common_dialog_cancel.setOnClickListener {
            mListener?.onCancel()
        }
        ydl_common_dialog_sure.setOnClickListener {
            mListener?.onSure()
        }

    }

    /**
     * 标题
     */
    fun setTitle(title: String): YDLCommonDialog {
        mTitle = title
        return this
    }

    /**
     * 内容
     */
    fun setDesc(desc: String): YDLCommonDialog {
        mDesc = desc
        return this
    }

    /**
     * 设置无标题弹窗描述
     */
    fun setNullTitleDesc(desc: String): YDLCommonDialog {
        hasTitle = false
        mDesc = desc
        return this
    }

    /**
     * 左侧按钮
     */
    fun setCancelText(cancelText: String): YDLCommonDialog {
        mLeftText = cancelText
        return this
    }

    /**
     * 右侧按钮
     */
    fun setSureText(sureText: String): YDLCommonDialog {
        mRightText = sureText
        return this
    }

    interface OnYDLCommonDialogListener {
        fun onCancel()
        fun onSure()
    }


}