package com.ydl.ydlcommon.view.swapelayout

import androidx.recyclerview.widget.GridLayoutManager
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import android.widget.AbsListView.OnScrollListener.SCROLL_STATE_IDLE


/**
 * @author yuanwai
 * @描述:上拉加载更多帮助类
 * @Copyright Copyright (c) 2018
 * @Company 壹点灵
 * @date 2018/7/26
 */
class YDLSwipeToLoadHelper(recyclerView: RecyclerView, private val mAdapterWrapper: YDLAdapterWrapper) : RecyclerView.OnScrollListener(),
    YDLAdapterWrapper.FooterCallBack {


    private val mRecyclerView: RecyclerView? = null
    private val mLayoutManager: RecyclerView.LayoutManager? = recyclerView.layoutManager
    private var mListener: LoadMoreListener? = null
    /** 是否正在加载中  */
    private var mLoading = false
    /** 上拉刷新功能是否开启  */
    private var mIsSwipeToLoadEnabled = true
    private var lastCompletePosition = 0

    init {

        if (mLayoutManager is GridLayoutManager) {
            mAdapterWrapper.setAdapterType(YDLAdapterWrapper.ADAPTER_TYPE_GRID)
            mAdapterWrapper.setSpanCount(mLayoutManager.spanCount)
        } else if (mLayoutManager is LinearLayoutManager) {
            mAdapterWrapper.setAdapterType(YDLAdapterWrapper.ADAPTER_TYPE_LINEAR)
        }
        mAdapterWrapper.setFooterCallBack(this)
        // 将OnScrollListener设置RecyclerView
        recyclerView.addOnScrollListener(this)
    }

    override fun onScrollStateChanged(recyclerView: RecyclerView, newState: Int) {
        if (mIsSwipeToLoadEnabled && SCROLL_STATE_IDLE === newState && !mLoading) {
            if (mLayoutManager is GridLayoutManager) {
                val gridLayoutManager = mLayoutManager
                gridLayoutManager.spanSizeLookup = object : GridLayoutManager.SpanSizeLookup() {
                    override fun getSpanSize(position: Int): Int {
                        return if (mIsSwipeToLoadEnabled) {
                            // 功能开启, 根据位置判断, 最后一个item时返回整个宽度, 其他位置返回1
                            // AdapterWrapper会保证最后一个item会从新的一行开始
                            if (position == mLayoutManager.getItemCount() - 1) {
                                gridLayoutManager.spanCount
                            } else {
                                1
                            }
                        } else {
                            1
                        }
                    }
                }
            }

            if (mLayoutManager is LinearLayoutManager) {
                val linearLayoutManager = mLayoutManager

                // only when the complete visible item is second last
//                if (lastCompletePosition == mLayoutManager.getItemCount() - 2) {
//                    val firstCompletePosition = linearLayoutManager.findFirstCompletelyVisibleItemPosition()
//                    val child = linearLayoutManager.findViewByPosition(lastCompletePosition)
//                            ?: return
//                    val deltaY = recyclerView!!.bottom - recyclerView.paddingBottom - child.bottom
//                    if (deltaY > 0 && firstCompletePosition != 0) {
//                        recyclerView.smoothScrollBy(0, -deltaY)
//                    }
//                } else
                if (linearLayoutManager.getChildCount() > 0 && lastCompletePosition >= mLayoutManager.getItemCount() - 1) {
                    // 最后一项完全显示, 触发操作, 执行加载更多操作 禁用回弹判断
                    mLoading = true
                    mAdapterWrapper.setLoadItemState(IYDLSwipeConfig.STATUS_LOADING)
                    if (mListener != null) {
                        mListener!!.onLoad()
                    }
                }
            }
        }
    }

    override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
        super.onScrolled(recyclerView, dx, dy)
        if (mLayoutManager is LinearLayoutManager) {
            val linearLayoutManager = mLayoutManager
            lastCompletePosition = linearLayoutManager.findLastCompletelyVisibleItemPosition()
        }
    }

    /** 设置下拉刷新功能是否开启  */
    fun setSwipeToLoadEnabled(isSwipeToLoadEnabled: Boolean) {
        if (mIsSwipeToLoadEnabled != isSwipeToLoadEnabled) {
            mIsSwipeToLoadEnabled = isSwipeToLoadEnabled
            mAdapterWrapper.setLoadItemVisibility(isSwipeToLoadEnabled)
        }
    }

    /** 设置LoadMore Item为加载完成状态, 上拉加载更多完成时调用  */
    fun setLoadMoreFinish() {
        mLoading = false
        mAdapterWrapper.setLoadItemState(IYDLSwipeConfig.STATUS_UP_LOAD)
    }

    /**
     * 设置LoadMore Item为没有更多数据状态 显示查看全部测评
     */
    fun setNoMoreData() {
        mLoading = true
        mAdapterWrapper.setLoadItemState(IYDLSwipeConfig.STATUS_UI)
    }

    override fun click() {
//        mListener!!.click()
    }

    /** 上拉操作触发时调用的接口  */
    fun setLoadMoreListener(loadMoreListener: LoadMoreListener) {
        mListener = loadMoreListener
    }

    interface LoadMoreListener {
        /**
         * 加载更多
         */
        fun onLoad()
    }
}