package com.ydl.ydlcommon.view.widgets;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;

/**
 * 下载进度提示view
 * @desc 此view的宽度需与progressBar宽度一致，且左右对齐
 */
public class DownProgressView extends SurfaceView implements SurfaceHolder.Callback {

    private SurfaceHolder surfaceHolder;
    private boolean canDraw = false;
    private Thread surfaceThread;

    //文本背景画笔
    Paint _paintTextBg;
    //文本画笔
    Paint _paintText;
    //内圆画笔
    Paint _paintIn;
    //外圆画笔
    Paint _paintOut;

    //原始顶点坐标
    private int oldX = 0;

    //文本背景颜色
    private String textBackgroundColor = "#E7E7E7";
    //文本颜色
    private String textColor = "#888888";
    //外圆颜色
    private String cirOutColor = "#6BCEFF";
    //内圆颜色
    private String cirInColor = "#FFFFFF";

    //当前进度
    private int progress = 0;

    private int squareWidth = 70; //圆角矩形宽度
    private int squareHeight = 40;//圆角矩形高度
    private int triangleWidth = 5;//三角形边长
    private int circleOutRdius = 30;//外圆半径
    private int circleInRdius = 15;//内圆半径

    private int mTextSize = 20;//文本大小

    public DownProgressView(Context context) {
        super(context);
        init();
    }

    public DownProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public DownProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init(){
        surfaceHolder = getHolder();
        surfaceHolder.addCallback(this);
        setZOrderOnTop(true);
        surfaceHolder.setFormat(PixelFormat.TRANSLUCENT);

        //文本背景画笔
        _paintTextBg = new Paint();
        _paintTextBg.setColor(Color.parseColor(textBackgroundColor));
        //文本画笔
        _paintText = new Paint();
        _paintText.setColor(Color.parseColor(textColor));
        _paintText.setTextSize(mTextSize);
        _paintText.setTextAlign(Paint.Align.CENTER);

        //内圆画笔
        _paintIn = new Paint();
        _paintIn.setColor(Color.parseColor(cirInColor));
        _paintIn.setAntiAlias(true);
        //外圆画笔
        _paintOut = new Paint();
        _paintOut.setColor(Color.parseColor(cirOutColor));
        _paintOut.setAntiAlias(true);
    }

    /**
     * 设置颜色参数(十六进制色值)
     * @param textBackgroundColor
     * @param textColor
     * @param cirOutColor
     * @param cirInColor
     */
    public void setColorParams(String textBackgroundColor,String textColor,String cirOutColor,String cirInColor){
        this.textBackgroundColor = textBackgroundColor;
        this.textColor = textColor;
        this.cirOutColor = cirOutColor;
        this.cirInColor = cirInColor;
    }

    /**
     * 设置尺寸大小（单位dp）
     * @param squareWidth
     * @param squareHeight
     * @param triangleWidth
     * @param circleOutRdius
     * @param circleInRdius
     */
    public void setSize(int squareWidth,int squareHeight,int triangleWidth,int circleOutRdius,int circleInRdius){
        this.squareWidth = dp2px(squareWidth);
        this.squareHeight = dp2px(squareHeight);
        this.triangleWidth = dp2px(triangleWidth);
        this.circleOutRdius = dp2px(circleOutRdius);
        this.circleInRdius = dp2px(circleInRdius);
    }

    /**
     * 设置文本大小(dp)
     * @param textSize
     */
    public void setTextSize(int textSize){
        this.mTextSize = dp2px(textSize);
    }

    public void setProgress(int progress){
        if (progress>100)return;
        this.progress = progress;
        int measureW = getMeasuredWidth();
        int tx = (int)(progress/100f*measureW);
        setX(tx);
        canDraw = true;
    }

    /**
     * 將 dip 或 dp 转换为 px, 保证尺寸大小不变
     *
     * @param dipValue
     * @return
     */
    public int dp2px(float dipValue) {
        final float scale = getResources().getDisplayMetrics().density;
        return (int) (dipValue * scale + 0.5f);
    }

    private void drawProgress(){
        Log.e("AAAAA",Thread.currentThread().getName());
        Canvas canvas = surfaceHolder.lockCanvas();
        try {
            //清空画布，进行重绘
            canvas.drawColor(Color.TRANSPARENT, PorterDuff.Mode.CLEAR);
            //画圆角矩形
            RectF rectF = new RectF();
            rectF.top = 0;
            rectF.right = oldX+squareWidth;
            rectF.bottom = squareHeight;
            rectF.left = oldX;
            canvas.drawRoundRect(rectF,dp2px(2),dp2px(2),_paintTextBg);
            //画进度文本
            Paint.FontMetrics fontMetrics = _paintText.getFontMetrics();
            float bottomLineY = rectF.centerY() - (fontMetrics.bottom - fontMetrics.top) / 2 - fontMetrics.top;
            canvas.drawText(progress+"%",oldX+squareWidth/2,bottomLineY,_paintText);
            Log.e("AAAAA",""+progress);
            //画三角行
            Path mPath = new Path();
            mPath.moveTo(oldX+(squareWidth/2-triangleWidth/2),squareHeight);
            mPath.lineTo(oldX+(squareWidth/2+triangleWidth/2),rectF.bottom);
            mPath.lineTo(oldX+(squareWidth/2),squareHeight+triangleWidth/1.5f);
            mPath.lineTo(oldX+(squareWidth/2-triangleWidth/2),squareHeight);
            mPath.close();
            canvas.drawPath(mPath,_paintTextBg);
            //画外圈圆
            canvas.drawCircle(oldX+squareWidth/2,squareHeight+dp2px(15),circleOutRdius,_paintOut);
            //画内圈圆
            canvas.drawCircle(oldX+squareWidth/2,squareHeight+dp2px(15),circleInRdius,_paintIn);
        }catch (Exception e){
            e.printStackTrace();
        }finally {
            try {
                surfaceHolder.unlockCanvasAndPost(canvas);
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }

    @Override
    public void surfaceCreated(SurfaceHolder holder) {
        canDraw = true;
        surfaceThread = new Thread(new Runnable() {
            @Override
            public void run() {
                while (canDraw){
                    drawProgress();
                }
            }
        });
        surfaceThread.start();
    }

    @Override
    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {

    }

    @Override
    public void surfaceDestroyed(SurfaceHolder holder) {
        canDraw = false;
    }
}
