package com.ydl.ydlcommon.view.widgets;

import android.content.Context;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;

/**
 * Created by xiongyu on 2017/5/2.
 */

public class MultiSwipeRefreshLayout extends SwipeRefreshLayout {

    private View view;
    public MultiSwipeRefreshLayout(Context context) {
        super(context);
    }

    public MultiSwipeRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setViewGroup(View view) {
        this.view = view;
    }



    @Override
    public boolean canChildScrollUp() {
        if (view != null && view instanceof RecyclerView) {
            final RecyclerView recyclerView = (RecyclerView) view;
            return recyclerView.getChildCount() > 0
                    && (((LinearLayoutManager) recyclerView.getLayoutManager()).findFirstVisibleItemPosition()> 0 || recyclerView.getChildAt(0)
                    .getTop() < recyclerView.getPaddingTop());
        }
        return super.canChildScrollUp();
    }
}