package com.ydl.ydlcommon.view.widgets;

import android.content.Context;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.ydl.ydlcommon.R;


/**
 * 顶部左右切换的布局控件
 */
public class TopTabSelectLayout extends LinearLayout implements View.OnClickListener {
    private Context mContext;
    private View mView;

    private RelativeLayout mToplayout;
    private ImageView mTopLeftIv;

    private RelativeLayout mTopReturnLayout;
    private TextView mLeftTv;
    private TextView mRightTv;

    private View mLineView;

    private LinearLayout mTitleBgLayout;

    private RelativeLayout mTopRightLayout;
    //    private TextView mRightActionTv;
    private ImageView mRightIv;

    /**
     * 选中时候左边背景颜色
     */
    private int mPressedLeftBgSourceId;
    /**
     * 选中时候右边背景颜色
     */
    private int mPressedRightBgSourceId;
    /**
     * 未选中背景左边颜色
     */
    private int mNormalLeftBgSourceId;
    /**
     * 未选中背景右边颜色
     */
    private int mNormalRightBgSourceId;

    /**
     * 选中时候字体颜色
     */
    private int mPressedTextColorId;
    /**
     * 未选中字体颜色
     */
    private int mNormalTextColorId;

    public TopTabSelectLayout(Context context) {
        super(context);
        initView(context);
    }

    public TopTabSelectLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        initView(context);
    }


    private void initView(Context context) {
        mContext = context;
        mView = LayoutInflater.from(mContext).inflate(R.layout.platform_top_select_layout, this, true);

        mTitleBgLayout = mView.findViewById(R.id.title_bg_layout);

        mToplayout = mView.findViewById(R.id.top_layout_rl);
        mTopLeftIv = mView.findViewById(R.id.iv_left);

        mTopReturnLayout = mView.findViewById(R.id.rl_left_top);
        mLeftTv = mView.findViewById(R.id.top_left_tv);
        mRightTv = mView.findViewById(R.id.top_right_tv);

        mTopRightLayout = mView.findViewById(R.id.rl_right_top);
//        mRightActionTv = (TextView) mView.findViewById(R.id.tv_right);
        mRightIv = mView.findViewById(R.id.iv_right);

        mLineView = mView.findViewById(R.id.line_view);

        mTopReturnLayout.setOnClickListener(this);
        mLeftTv.setOnClickListener(this);
        mRightTv.setOnClickListener(this);

        mPressedLeftBgSourceId = R.drawable.platform_round_left_green;
        mPressedRightBgSourceId = R.drawable.platform_round_right_green;
        mNormalLeftBgSourceId = R.drawable.platform_round_left_white;
        mNormalRightBgSourceId = R.drawable.platform_round_right_white;

        mPressedTextColorId = R.color.platform_white;
        mNormalTextColorId = R.color.platform_main_theme;

        setSelectIndex(0);
    }


    @Override
    public void onClick(View v) {
        if (v.getId() == R.id.top_left_tv) {
            setSelectIndex(0);
            if (listener != null) {
                listener.selectTabClickListener(0);
            }
        } else if (v.getId() == R.id.top_right_tv) {
            setSelectIndex(1);
            if (listener != null) {
                listener.selectTabClickListener(1);
            }
        } else if (v.getId() == R.id.rl_left_top) {
            if (listener != null) {
                listener.onReturnClickListener();
            }
        }
    }

    /**
     * 设置右边文案
     *
     * @param text
     */
    public void setRightTvText(String text) {
        String str = TextUtils.isEmpty(text) ? "" : text;
//        mRightActionTv.setText(Html.fromHtml(str));
        mTopRightLayout.setVisibility(TextUtils.isEmpty(text) ? GONE : VISIBLE);
    }

    /**
     * 设置右边字体颜色
     *
     * @param colorId
     */
    public void setRightTvTextColor(int colorId) {
        if (colorId > 0) {
//            mRightActionTv.setTextColor(ContextCompat.getColor(mContext, colorId));
            mTopRightLayout.setVisibility(VISIBLE);
        } else {
            mTopRightLayout.setVisibility(GONE);
        }
    }

    /**
     * 设置右边icon
     *
     * @param sourceId
     */
    public void setRightIvSource(int sourceId) {
        if (sourceId > 0) {
            mRightIv.setImageResource(sourceId);
            mTopRightLayout.setVisibility(VISIBLE);
        } else {
            mTopRightLayout.setVisibility(GONE);
        }
    }

    /**
     * 设置右边的点击事件
     *
     * @param listener
     */
    public void setOnClickRightListener(final OnClickListener listener) {
        mTopRightLayout.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
            }
        });
    }


    /**
     * 设置整块布局背景颜色
     *
     * @param colorId
     */
    public void setBackgroundByColorId(int colorId) {
        if (colorId > 0) {
            mToplayout.setBackgroundColor(ContextCompat.getColor(mContext, colorId));
        }
    }

    /**
     * 设置左边按钮图标
     *
     * @param iconId
     */
    public void setLeftIvIcon(int iconId) {
        if (iconId > 0) {
            mTopLeftIv.setImageResource(iconId);
        }
    }

    public void setLeftGone() {
        mTopReturnLayout.setVisibility(GONE);
    }

    /**
     * 设置标题
     *
     * @param leftTtile
     * @param rightTitle
     */
    public void setButtonTitle(String leftTtile, String rightTitle) {
        mLeftTv.setText(TextUtils.isEmpty(leftTtile) ? "" : leftTtile);
        mRightTv.setText(TextUtils.isEmpty(rightTitle) ? "" : rightTitle);
    }

    /**
     * 设置没有选中时候字体颜色
     *
     * @param colorId
     */
    public void setNormalTextColor(int colorId) {
        if (colorId > 0) {
            mNormalTextColorId = colorId;
        }
    }

    /**
     * 选中时候字体颜色
     *
     * @param colorId
     */
    public void setPressedTextColor(int colorId) {
        if (colorId > 0) {
            mPressedTextColorId = colorId;
        }
    }

    public void setLineViewVisible(int visible) {
        mLineView.setVisibility(visible);
    }

    /**
     * 设置选中不选中背景
     *
     * @param mNormalLeftBgId   左边未选中时候背景
     * @param mNormalRightBgId  右边未选中时候背景
     * @param mPressedLeftBgId  左边选中时候背景
     * @param mPressedRightBgId 右边选中时候背景
     */
    public void setButtonBackground(int mNormalLeftBgId, int mNormalRightBgId, int mPressedLeftBgId, int mPressedRightBgId) {
        mPressedLeftBgSourceId = mPressedLeftBgId;
        mPressedRightBgSourceId = mPressedRightBgId;
        mNormalLeftBgSourceId = mNormalLeftBgId;
        mNormalRightBgSourceId = mNormalRightBgId;
    }

    /**
     * 设置右边未选中时候背景
     *
     * @param mNormalRightBgId
     */
    public void setRightNormalBgSourceId(int mNormalRightBgId) {
        mNormalRightBgSourceId = mNormalRightBgId;
    }

    /**
     * 设置左边边未选中时候背景
     *
     * @param mNormalLeftBgId
     */
    public void setLeftNormalBgSourceId(int mNormalLeftBgId) {
        mNormalLeftBgSourceId = mNormalLeftBgId;
    }

    /**
     * 设置选中不选中背景
     *
     * @param mPressedLeftBgId  左边选中时候背景
     * @param mPressedRightBgId 右边选中时候背景
     */
    public void setButtonBackground(int mPressedLeftBgId, int mPressedRightBgId) {
        mPressedLeftBgSourceId = mPressedLeftBgId;
        mPressedRightBgSourceId = mPressedRightBgId;
    }


    /**
     * 标题栏边框颜色
     *
     * @param mTitleBgId
     */
    public void setTitleFrameBackground(int mTitleBgId) {
        if (mTitleBgId > 0) {
            mTitleBgLayout.setBackgroundResource(mTitleBgId);
        } else {
            mTitleBgLayout.setBackgroundResource(R.drawable.platform_round_corner_white_bg_red_line);
        }
    }

    /**
     * 选中状态
     *
     * @param index 0;1
     */
    public void setSelectIndex(int index) {
        if (index == 0) {
            mLeftTv.setTextColor(ContextCompat.getColor(mContext, mPressedTextColorId));
            mLeftTv.setBackgroundResource(mPressedLeftBgSourceId);

            mRightTv.setTextColor(ContextCompat.getColor(mContext, mNormalTextColorId));
            mRightTv.setBackgroundResource(mNormalRightBgSourceId);
        } else {
            mLeftTv.setTextColor(ContextCompat.getColor(mContext, mNormalTextColorId));
            mLeftTv.setBackgroundResource(mNormalLeftBgSourceId);

            mRightTv.setTextColor(ContextCompat.getColor(mContext, mPressedTextColorId));
            mRightTv.setBackgroundResource(mPressedRightBgSourceId);
        }
    }

    public OnSelectTabClickListener listener;

    public void setOnSelectTabClickListener(OnSelectTabClickListener listener) {
        this.listener = listener;
    }


    public interface OnSelectTabClickListener {
        void selectTabClickListener(int index);

        void onReturnClickListener();
    }

}
