package com.yidianling.common.tools

import android.app.Activity
import android.content.Context
import android.view.ContextThemeWrapper
import androidx.fragment.app.FragmentActivity

fun Context.asActivity(): Activity? {
    if (this is Activity) {
        return this
    }
    if (this is ContextThemeWrapper) {
        return this.baseContext.asActivity()
    }
    return null
}

fun Context.asFragmentActivity(): FragmentActivity? {
    if (this is FragmentActivity) {
        return this
    }
    if (this is ContextThemeWrapper) {
        return this.baseContext.asFragmentActivity()
    }
    return null
}