package com.ydl.utils

import android.content.Context
import android.text.TextUtils

/**
 * Created by Ykai on 2021/4/1.
 */
object ProxyCheckUtils {

    /**
     * 判断设备 是否使用代理上网
     * @param context 上下文对象
     * return  当前网络是否开启了代理
     */
    fun isWifiProxy(context: Context): Boolean {
        val proxyAddress: String = System.getProperty("http.proxyHost") ?: ""
        val portStr = System.getProperty("http.proxyPort")
        val proxyPort = (portStr ?: "-1").toInt()

        return !TextUtils.isEmpty(proxyAddress) && proxyPort != -1
    }
}