package com.ydl.view

import android.os.Bundle
import android.util.DisplayMetrics
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.EditText
import android.widget.ImageView
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.fragment.app.DialogFragment
import com.blankj.utilcode.util.KeyboardUtils
import com.ydl.webview.R
import com.ydl.ydlcommon.utils.actionutil.ActionCountUtils
import com.ydl.ydlcommon.utils.remind.ToastHelper

class ArticleDialogFragment: DialogFragment() {

    private lateinit var ivClose: ImageView
    private lateinit var etComment: EditText
    private lateinit var tvPublish: TextView
    private lateinit var cslLayout:ConstraintLayout
    private lateinit var mListener: OnPublishArticleCommentListener

    private var mTitle:String = ""

    fun setOnPublishListener(listener: OnPublishArticleCommentListener){
        mListener = listener
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NO_TITLE, R.style.BottomDialogAnimation)
    }

    override fun onStart() {
        super.onStart()
        val displayMetrics = DisplayMetrics()
        activity?.windowManager?.defaultDisplay?.getMetrics(displayMetrics)
        val window = dialog?.window
        window?.setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val view = inflater.inflate(R.layout.layout_comment_article,container)
        initView(view)
        return view
    }

    private fun initView(view: View){

        mTitle = arguments?.getString(KEY_ARTICLE_TITLE)?:""

        ivClose = view.findViewById(R.id.iv_close_dialog)
        etComment = view.findViewById(R.id.et_article_comment)
        tvPublish = view.findViewById(R.id.tv_publish_comment)
        cslLayout = view.findViewById(R.id.csl_root_layout)

        cslLayout.setOnClickListener {
            ActionCountUtils.record("article_detail_page","article_detail_cancelcomment_click",mTitle)
            dismiss()
        }

        KeyboardUtils.showSoftInput(etComment)

        ivClose.setOnClickListener {
            ActionCountUtils.record("article_detail_page","article_detail_cancelcomment_click",mTitle)
            dismiss()
        }
        tvPublish.setOnClickListener {
            if (etComment.text.toString().isNullOrBlank()){
                ToastHelper.show("评论内容不能为空～")
                return@setOnClickListener
            }
            mListener.onPublishClick(etComment.text.toString())
            ActionCountUtils.record("article_detail_page","article_detail_issuecomment_click",mTitle)
            etComment.setText("")
            dismiss()
        }

    }

    override fun dismiss() {
        KeyboardUtils.hideSoftInput(etComment)
        super.dismiss()
    }

    companion object {

        private const val KEY_ARTICLE_TITLE = "key_share_title"

        @JvmStatic
        fun newInstance(title: String): ArticleDialogFragment {
            val args = Bundle()
            args.putString(KEY_ARTICLE_TITLE, title)
            val fragment = ArticleDialogFragment()
            fragment.arguments = args
            return fragment
        }

    }

    interface OnPublishArticleCommentListener{
        fun onPublishClick(comment:String)
    }

}