package com.ydl.view


import android.app.Activity
import android.graphics.Color
import android.os.Bundle
import android.util.DisplayMetrics
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.view.ViewGroup.LayoutParams.MATCH_PARENT
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import androidx.constraintlayout.widget.ConstraintLayout
import androidx.fragment.app.DialogFragment
import com.umeng.socialize.bean.SHARE_MEDIA
import com.ydl.webview.R
import com.ydl.ydlcommon.actions.share.ShareUtils


class ShareMeditationDialog : DialogFragment() {

    private var llRootLayout:ConstraintLayout?=null

    private var llWeChat: LinearLayout? = null
    private var llCircleOfFriends: LinearLayout? = null
    private var llSave: LinearLayout? = null
    private var llQQZone: LinearLayout? = null
    private var llQQFriend: LinearLayout? = null

    private var ivWeChat: ImageView? = null
    private var ivCircleOfFriends: ImageView? = null
    private var ivQQZone: ImageView? = null
    private var ivQQFriend: ImageView? = null

    private var tvWeChat: TextView? = null
    private var tvCircleOfFriends: TextView? = null
    private var tvQQZone: TextView? = null
    private var tvQQFriend: TextView? = null
    private var tvCancel: TextView? = null

    private var cslLayout:ConstraintLayout?=null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setStyle(STYLE_NO_TITLE, R.style.share_meditation_dialog)
    }

    override fun onStart() {
        super.onStart()
        val displayMetrics = DisplayMetrics()
        activity?.windowManager?.defaultDisplay?.getMetrics(displayMetrics)
        val window = dialog?.window
        window?.setLayout(MATCH_PARENT, MATCH_PARENT)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        val view = inflater.inflate(R.layout.layout_share_meditation_dialog, container)
        initView(view)
        return view
    }

    private fun initView(view: View?) {

        val isDarkMode = arguments?.getBoolean(KEY_SHARE_DARK_MODE)
        val shareUrl = arguments?.getString(KEY_SHARE_URL)
        val shareTitle = arguments?.getString(KEY_SHARE_TITLE)
        val shareContent = arguments?.getString(KEY_SHARE_CONTENT)
        val shareCover = arguments?.getString(KEY_SHARE_COVER)
        val miniId = arguments?.getString(KEY_SHARE_MINI_ID)
        val miniPath = arguments?.getString(KEY_SHARE_MINI_PATH)

        llRootLayout = view?.findViewById(R.id.csl_share_layout)
        cslLayout = view?.findViewById(R.id.csl_root_layout)

        llWeChat = view?.findViewById(R.id.ll_wechat_friend)
        llCircleOfFriends = view?.findViewById(R.id.ll_wechat_circle_of_friends)
        llSave = view?.findViewById(R.id.ll_save_picture)
        llQQZone = view?.findViewById(R.id.ll_qq_zone)
        llQQFriend = view?.findViewById(R.id.ll_qq_friend)

        ivWeChat = view?.findViewById(R.id.iv_wechat)
        tvWeChat = view?.findViewById(R.id.tv_wechat)
        ivCircleOfFriends = view?.findViewById(R.id.iv_circle)
        tvCircleOfFriends = view?.findViewById(R.id.tv_circle)
        ivQQZone = view?.findViewById(R.id.iv_qq_zone)
        tvQQZone = view?.findViewById(R.id.tv_qq_zone)
        ivQQFriend = view?.findViewById(R.id.iv_qq)
        tvQQFriend = view?.findViewById(R.id.tv_qq)

        tvCancel = view?.findViewById(R.id.tv_cancel_share)

        updateUI(isDarkMode == true)

        cslLayout?.setOnClickListener {
            dismiss()
        }

        llWeChat?.setOnClickListener {
            ShareUtils.shareSmailWeixin(
                activity as Activity,
                shareTitle!!,
                shareUrl!!,
                shareContent!!,
                shareCover!!,
                path = miniPath,
                id = miniId,
                shareListener = null
            )
            dismiss()
        }

        llCircleOfFriends?.setOnClickListener {
            ShareUtils.shareTo(
                SHARE_MEDIA.WEIXIN_CIRCLE,
                activity as Activity,
                shareTitle!!,
                shareUrl!!,
                shareContent!!,
                shareCover!!
            )
            dismiss()
        }

        llSave?.setOnClickListener {
            dismiss()
        }

        llQQZone?.setOnClickListener {
            ShareUtils.shareTo(
                SHARE_MEDIA.QZONE,
                activity as Activity,
                shareTitle!!,
                shareUrl!!,
                shareContent!!,
                shareCover!!
            )
            dismiss()
        }

        llQQFriend?.setOnClickListener {
            ShareUtils.shareTo(
                SHARE_MEDIA.QQ,
                activity as Activity,
                shareTitle!!,
                shareUrl!!,
                shareContent!!,
                shareCover!!
            )
            dismiss()
        }

        tvCancel?.setOnClickListener {
            dismiss()
        }

    }

    private fun updateUI(isDarkMode: Boolean){
        if (isDarkMode){
            llRootLayout?.setBackgroundResource(R.drawable.bg_share_play_meditation_bottom_dark)

            ivWeChat?.setImageResource(R.drawable.ic_icon_weixin)
            ivCircleOfFriends?.setImageResource(R.drawable.ic_icon_friends)
            ivQQZone?.setImageResource(R.drawable.ic_icon_qqzone)
            ivQQFriend?.setImageResource(R.drawable.ic_icon_qq)

            tvWeChat?.setTextColor(Color.parseColor("#FF84AACE"))
            tvCircleOfFriends?.setTextColor(Color.parseColor("#FF84AACE"))
            tvQQZone?.setTextColor(Color.parseColor("#FF84AACE"))
            tvQQFriend?.setTextColor(Color.parseColor("#FF84AACE"))
            tvCancel?.setTextColor(Color.parseColor("#FFFFFFFF"))
        }else{
            llRootLayout?.setBackgroundResource(R.drawable.bg_share_play_meditation_bottom)

            ivWeChat?.setImageResource(R.drawable.icon_meditation_share_wechat)
            ivCircleOfFriends?.setImageResource(R.drawable.icon_meditation_share_friends)
            ivQQZone?.setImageResource(R.drawable.icon_meditation_share_qqzone)
            ivQQFriend?.setImageResource(R.drawable.icon_meditation_share_qq)

            tvWeChat?.setTextColor(Color.parseColor("#FF666666"))
            tvCircleOfFriends?.setTextColor(Color.parseColor("#FF666666"))
            tvQQZone?.setTextColor(Color.parseColor("#FF666666"))
            tvQQFriend?.setTextColor(Color.parseColor("#FF666666"))
            tvCancel?.setTextColor(Color.parseColor("#FF242424"))
        }
    }

    companion object {
        const val TAG = "ShareMeditationDialog"

        private const val KEY_SHARE_DARK_MODE = "key_share_dark_mode"
        private const val KEY_SHARE_URL = "key_share_url"
        private const val KEY_SHARE_TITLE = "key_share_title"
        private const val KEY_SHARE_CONTENT = "key_share_content"
        private const val KEY_SHARE_COVER = "key_share_cover"
        private const val KEY_SHARE_MINI_ID = "key_share_mini_id"
        private const val KEY_SHARE_MINI_PATH = "key_share_mini_path"

        fun newInstance(
            isDarkMode: Boolean, shareUrl: String, shareTitle: String,
            shareContent: String, shareCover: String, miniId: String, miniPath: String
        ): ShareMeditationDialog {
            val args = Bundle()
            args.putBoolean(KEY_SHARE_DARK_MODE, isDarkMode)
            args.putString(KEY_SHARE_URL, shareUrl)
            args.putString(KEY_SHARE_TITLE, shareTitle)
            args.putString(KEY_SHARE_CONTENT, shareContent)
            args.putString(KEY_SHARE_COVER, shareCover)
            args.putString(KEY_SHARE_MINI_ID, miniId)
            args.putString(KEY_SHARE_MINI_PATH, miniPath)

            val fragment = ShareMeditationDialog()
            fragment.arguments = args
            return fragment
        }

    }

}