package com.ydl.webview

import android.app.Activity
import com.ydl.ydlcommon.modular.ModularServiceManager
import com.yidianling.dynamic.api.IDynamicService
import com.yidianling.im.api.service.IImService
import com.yidianling.user.api.service.IAppService
import com.yidianling.user.api.service.IUserService

/**
 * Created by haorui on 2019-10-10.
 * Des:
 */
class WebModularServiceUtils {

    companion object {

        fun getImService(): IImService {
            return ModularServiceManager.provide(IImService::class.java)
        }


        fun getDynamicService(): IDynamicService {
            return ModularServiceManager.provide(IDynamicService::class.java)
        }

        fun getAppService(): IAppService {
            return ModularServiceManager.provide(IAppService::class.java)
        }

        fun getUserService(): IUserService {
            return ModularServiceManager.provide(IUserService::class.java)
        }

        fun getWebService(): IWebService {
            return ModularServiceManager.provide(IWebService::class.java)
        }

        fun  startMain(activity: Activity){
            getAppService().mainIntent(activity)

        }
    }
}
