package com.ydl.component.music

import android.content.Context
import android.content.Intent
import androidx.fragment.app.Fragment
import com.ydl.component.mvp.DemoContract
import com.ydl.component.mvp.DemoPresenter
import com.ydl.ydlcommon.bean.StatusBarOptions
import com.ydl.ydlcommon.mvp.lce.BaseLceActivity
import com.yidianling.consultant.ExpertSearchFragment
//import com.yidianling.consultant.ExpertSearchFragment
import com.yidianling.dynamic.trendsHome.TrendsHomeFragment
import com.yidianling.home.ui.fragment.YdlHomeFragment
//import com.yidianling.dynamic.trendsHome.TrendsHomeFragment
//import com.yidianling.home.ui.fragment.YdlHomeFragment
import com.yidianling.im.ui.page.NewMultiMessageFragment
import com.yidianling.tests.home.NewTestHomeFragment
import com.yidianling.user.mine.MineFragment


class FragmentContainerActivity : BaseLceActivity<DemoContract.View, DemoContract.Presenter>(),
    DemoContract.View {

    companion object {
        fun start(context: Context, fragmentName: String = "") {
            val intent = Intent(context, FragmentContainerActivity::class.java)
            intent.putExtra("fragmentName", fragmentName)
            context.startActivity(intent)
        }
    }

    override fun getStatusViewOptions(): StatusBarOptions {
        return StatusBarOptions(isAddStatusView = true, statusBarDarkMode = true)
    }

    override fun getContentViewId(): Int {
        return com.ydl.component.R.id.lce_content_view
    }

    override fun getStateViewId(): Int {
        return com.ydl.component.R.id.lce_state_view
    }

    override fun createPresenter(): DemoContract.Presenter {
        return DemoPresenter()
    }

    override fun layoutResId(): Int {
        return com.ydl.component.R.layout.activity_fragment_container
    }

    override fun initDataAndEvent() {
        reLoadData()
    }

    override fun reLoadData() {
        mPresenter.loadFmMusic()
    }

    override fun setData(data: String) {
        val ft = supportFragmentManager.beginTransaction()
        ft.setCustomAnimations(com.ydl.component.R.anim.fragment_slide_up, 0)
        ft.replace(android.R.id.content, getFragment())
        ft.commitAllowingStateLoss()
    }

    private fun getFragment(): Fragment {
        val fragmentName = intent.getStringExtra("fragmentName") ?: ""
        if ("NewMultiMessageFragment" == fragmentName) {
            return NewMultiMessageFragment()
        }
        if ("TrendsHomeFragment" == fragmentName) {
            return TrendsHomeFragment()
        }
        if ("YdlHomeFragment" == fragmentName) {
            return YdlHomeFragment()
        }
        if ("ExpertSearchFragment" == fragmentName) {
            return ExpertSearchFragment()
        }
        if ("MineFragment" == fragmentName) {
            return MineFragment()
        }
        if ("NewTestHomeFragment" == fragmentName) {
            return NewTestHomeFragment()
        }
        return PlayFragment()
    }
}
